/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.edge;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.code.CodeEdge;
import java.util.Objects;

public abstract class Edge
implements CodeEdge<CFG, Statement, Edge> {
    private final Statement source;
    private final Statement destination;

    protected Edge() {
        this.source = null;
        this.destination = null;
    }

    protected Edge(Statement source, Statement destination) {
        Objects.requireNonNull(source, "The source of an edge cannot be null");
        Objects.requireNonNull(destination, "The destination of an edge cannot be null");
        this.source = source;
        this.destination = destination;
    }

    @Override
    public final Statement getSource() {
        return this.source;
    }

    @Override
    public final Statement getDestination() {
        return this.destination;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + this.getClass().getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public abstract String toString();

    public abstract <A extends AbstractState<A>> AnalysisState<A> traverseForward(AnalysisState<A> var1) throws SemanticException;

    public abstract <A extends AbstractState<A>> AnalysisState<A> traverseBackwards(AnalysisState<A> var1) throws SemanticException;

    @Override
    public <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        return visitor.visit(tool, this.source.getCFG(), this);
    }

    @Override
    public int compareTo(Edge o) {
        int cmp = this.source.compareTo(o.source);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.destination.compareTo(o.destination);
        if (cmp != 0) {
            return cmp;
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }
}

