/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.controlFlow;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.edge.SequentialEdge;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.code.NodeList;
import java.util.Collection;
import java.util.HashSet;

public abstract class ControlFlowStructure {
    protected final NodeList<CFG, Statement, Edge> cfgMatrix;
    private final Statement condition;
    private Statement firstFollower;

    protected ControlFlowStructure(NodeList<CFG, Statement, Edge> cfgMatrix, Statement condition, Statement firstFollower) {
        this.cfgMatrix = cfgMatrix;
        this.condition = condition;
        this.firstFollower = firstFollower;
    }

    public final Statement getCondition() {
        return this.condition;
    }

    public final Statement getFirstFollower() {
        return this.firstFollower;
    }

    public void setFirstFollower(Statement firstFollower) {
        this.firstFollower = firstFollower;
    }

    public final Collection<Statement> allStatements() {
        HashSet<Statement> all = new HashSet<Statement>(this.bodyStatements());
        all.add(this.getCondition());
        all.add(this.getFirstFollower());
        return all;
    }

    protected abstract Collection<Statement> bodyStatements();

    public abstract boolean contains(Statement var1);

    public abstract void simplify();

    public int distance(Statement st) {
        if (st == this.condition) {
            return 0;
        }
        if (st != this.firstFollower && !this.bodyStatements().contains(st)) {
            return -1;
        }
        return this.cfgMatrix.distance(this.condition, st);
    }

    public NodeList<CFG, Statement, Edge> getCompleteStructure() {
        NodeList<CFG, Statement, Edge> complete = new NodeList<CFG, Statement, Edge>(new SequentialEdge(), false);
        complete.addNode(this.getCondition());
        this.bodyStatements().forEach(complete::addNode);
        if (this.getFirstFollower() != null) {
            complete.addNode(this.getFirstFollower());
        }
        Collection nodes = complete.getNodes();
        for (Statement st : nodes) {
            for (Statement follow : this.cfgMatrix.followersOf(st)) {
                if (!nodes.contains(follow)) continue;
                complete.addEdge(this.cfgMatrix.getEdgeConnecting(st, follow));
            }
        }
        return complete;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.cfgMatrix == null ? 0 : this.cfgMatrix.hashCode());
        result = 31 * result + (this.firstFollower == null ? 0 : this.firstFollower.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlFlowStructure other = (ControlFlowStructure)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        if (this.cfgMatrix == null ? other.cfgMatrix != null : !this.cfgMatrix.equals(other.cfgMatrix)) {
            return false;
        }
        return !(this.firstFollower == null ? other.firstFollower != null : !this.firstFollower.equals(other.firstFollower));
    }

    public abstract String toString();

    public abstract Collection<Statement> getTargetedStatements();
}

