/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.controlFlow;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowStructure;
import it.unive.lisa.program.cfg.controlFlow.IfThenElse;
import it.unive.lisa.program.cfg.controlFlow.Loop;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.edge.FalseEdge;
import it.unive.lisa.program.cfg.edge.SequentialEdge;
import it.unive.lisa.program.cfg.edge.TrueEdge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.collections.workset.VisitOnceFIFOWorkingSet;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.algorithms.Dominators;
import it.unive.lisa.util.datastructures.graph.code.NodeList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ControlFlowExtractor {
    public Collection<ControlFlowStructure> extract(CFG target) {
        LinkedList conditionals = new LinkedList();
        target.accept(new ConditionalsExtractor(), conditionals);
        if (conditionals.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList remaining = new LinkedList(conditionals);
        HashMap<Statement, ControlFlowStructure> result = new HashMap<Statement, ControlFlowStructure>();
        Map dominators = new Dominators().build(target);
        block0: for (Statement conditional : conditionals) {
            for (Statement pred : target.predecessorsOf(conditional)) {
                if (!dominators.get(pred).contains(conditional)) continue;
                result.put(conditional, new LoopReconstructor(target, conditional, pred).build());
                remaining.remove(conditional);
                continue block0;
            }
        }
        for (Statement conditional : remaining) {
            result.put(conditional, new IfReconstructor(target, conditional, result).build());
        }
        return result.values();
    }

    private static boolean isConditional(CFG graph, Statement node) {
        Collection out = graph.getOutgoingEdges(node);
        if (out.size() != 2) {
            return false;
        }
        Iterator it = out.iterator();
        Edge first = (Edge)it.next();
        Edge second = (Edge)it.next();
        if (first instanceof TrueEdge && second instanceof FalseEdge) {
            return true;
        }
        return second instanceof TrueEdge && first instanceof FalseEdge;
    }

    private static class ConditionalsExtractor
    implements GraphVisitor<CFG, Statement, Edge, Collection<Statement>> {
        private ConditionalsExtractor() {
        }

        @Override
        public boolean visit(Collection<Statement> tool, CFG graph, Statement node) {
            if (node instanceof Expression && ((Expression)node).getRootStatement() != node) {
                return true;
            }
            if (ControlFlowExtractor.isConditional(graph, node)) {
                tool.add(node);
            }
            return true;
        }
    }

    private static class IfReconstructor {
        protected final CFG target;
        private final Statement conditional;
        private final Edge trueEdgeStartingEdge;
        private final Edge falseEdgeStartingEdge;
        private final NodeList<CFG, Statement, Edge> trueBranch;
        private final NodeList<CFG, Statement, Edge> falseBranch;
        private final Map<Statement, ControlFlowStructure> computed;

        private IfReconstructor(CFG target, Statement conditional, Map<Statement, ControlFlowStructure> computed) {
            this.target = target;
            this.conditional = conditional;
            this.computed = computed;
            this.trueBranch = new NodeList(new SequentialEdge(), false);
            this.falseBranch = new NodeList(new SequentialEdge(), false);
            Iterator it = target.getOutgoingEdges(conditional).iterator();
            Edge trueEdge = (Edge)it.next();
            Edge falseEdge = (Edge)it.next();
            if (trueEdge instanceof FalseEdge) {
                Edge tmp = trueEdge;
                trueEdge = falseEdge;
                falseEdge = tmp;
            }
            this.trueEdgeStartingEdge = trueEdge;
            this.falseEdgeStartingEdge = falseEdge;
        }

        private ControlFlowStructure build() {
            if (this.computed.containsKey(this.conditional)) {
                return this.computed.get(this.conditional);
            }
            Edge trueNext = this.trueEdgeStartingEdge;
            Edge falseNext = this.falseEdgeStartingEdge;
            Edge trueLast = null;
            Edge falseLast = null;
            boolean first = true;
            ControlFlowStructure struct;
            while (trueNext == null || falseNext == null || (struct = this.tryClose(trueNext.getDestination(), falseNext.getDestination())) == null) {
                Collection<Edge> ins;
                NodeList<CFG, Statement, Edge> completeStructure;
                boolean trueCond = trueNext != null && ControlFlowExtractor.isConditional(this.target, trueNext.getDestination());
                boolean trueCondProcessed = false;
                boolean falseCond = falseNext != null && ControlFlowExtractor.isConditional(this.target, falseNext.getDestination());
                boolean falseCondProcessed = false;
                if (trueCond) {
                    struct = this.computed.containsKey(trueNext.getDestination()) ? this.computed.get(trueNext.getDestination()) : new IfReconstructor(this.target, trueNext.getDestination(), this.computed).build();
                    completeStructure = struct.getCompleteStructure();
                    this.trueBranch.mergeWith(completeStructure);
                    this.trueBranch.addEdge(trueNext);
                    if (struct.getFirstFollower() == null) {
                        trueNext = null;
                    } else {
                        ins = completeStructure.getIngoingEdges(struct.getFirstFollower());
                        if (ins.isEmpty()) {
                            throw new IllegalStateException("The first follower of " + struct + " does not have ingoing edges");
                        }
                        trueNext = ins.iterator().next();
                    }
                    trueCondProcessed = true;
                } else if (falseCond) {
                    struct = this.computed.containsKey(falseNext.getDestination()) ? this.computed.get(falseNext.getDestination()) : new IfReconstructor(this.target, falseNext.getDestination(), this.computed).build();
                    completeStructure = struct.getCompleteStructure();
                    this.falseBranch.mergeWith(completeStructure);
                    this.falseBranch.addEdge(falseNext);
                    if (struct.getFirstFollower() == null) {
                        falseNext = null;
                    } else {
                        ins = completeStructure.getIngoingEdges(struct.getFirstFollower());
                        if (ins.isEmpty()) {
                            throw new IllegalStateException("The first follower of " + struct + " does not have ingoing edges");
                        }
                        falseNext = ins.iterator().next();
                    }
                    falseCondProcessed = true;
                }
                Collection trueOuts = null;
                Collection falseOuts = null;
                if (!falseCondProcessed && trueNext != null && trueNext != trueLast) {
                    trueLast = trueNext;
                    if (!trueCondProcessed) {
                        this.trueBranch.addNode(trueNext.getDestination());
                        if (!first) {
                            this.trueBranch.addEdge(trueNext);
                        }
                    }
                    if (!(trueOuts = this.target.getOutgoingEdges(trueNext.getDestination())).isEmpty()) {
                        trueNext = (Edge)trueOuts.iterator().next();
                    }
                } else {
                    trueOuts = null;
                }
                if (!trueCondProcessed && falseNext != null && falseNext != falseLast) {
                    falseLast = falseNext;
                    if (!falseCondProcessed) {
                        this.falseBranch.addNode(falseNext.getDestination());
                        if (!first) {
                            this.falseBranch.addEdge(falseNext);
                        }
                    }
                    if (!(falseOuts = this.target.getOutgoingEdges(falseNext.getDestination())).isEmpty()) {
                        falseNext = (Edge)falseOuts.iterator().next();
                    }
                } else {
                    falseOuts = null;
                }
                if (!(trueCondProcessed || falseCondProcessed || trueOuts != null && !trueOuts.isEmpty() || falseOuts != null && !falseOuts.isEmpty())) {
                    return this.store(new IfThenElse(this.target.getNodeList(), this.conditional, null, this.trueBranch.getNodes(), this.falseBranch.getNodes()));
                }
                first = false;
            }
            return this.store(struct);
        }

        private ControlFlowStructure tryClose(Statement trueNext, Statement falseNext) {
            if (this.falseBranch.containsNode(trueNext)) {
                this.falseBranch.removeFrom(trueNext);
                return new IfThenElse(this.target.getNodeList(), this.conditional, trueNext, this.trueBranch.getNodes(), this.falseBranch.getNodes());
            }
            if (this.trueBranch.containsNode(falseNext)) {
                this.trueBranch.removeFrom(falseNext);
                return new IfThenElse(this.target.getNodeList(), this.conditional, falseNext, this.trueBranch.getNodes(), this.falseBranch.getNodes());
            }
            if (trueNext.equals(falseNext)) {
                return new IfThenElse(this.target.getNodeList(), this.conditional, falseNext, this.trueBranch.getNodes(), this.falseBranch.getNodes());
            }
            return null;
        }

        private ControlFlowStructure store(ControlFlowStructure struct) {
            this.computed.put(struct.getCondition(), struct);
            return struct;
        }
    }

    private static class LoopReconstructor {
        private final CFG target;
        private final Statement conditional;
        private final Statement tail;

        private LoopReconstructor(CFG target, Statement conditional, Statement tail) {
            this.target = target;
            this.conditional = conditional;
            this.tail = tail;
        }

        private Loop build() {
            NodeList<CFG, Statement, Edge> body = new NodeList<CFG, Statement, Edge>(new SequentialEdge(), false);
            if (this.tail != this.conditional) {
                VisitOnceFIFOWorkingSet ws = VisitOnceFIFOWorkingSet.mk();
                this.target.getIngoingEdges(this.tail).forEach(ws::push);
                body.addNode(this.tail);
                while (!ws.isEmpty()) {
                    Edge current = (Edge)ws.pop();
                    if (current.getSource() == this.conditional) continue;
                    body.addNode(current.getSource());
                    body.addEdge(current);
                    this.target.getIngoingEdges(current.getSource()).forEach(ws::push);
                }
            }
            Edge exit = this.findExitEdge(body);
            return new Loop(this.target.getNodeList(), this.conditional, exit.getDestination(), body.getNodes());
        }

        private Edge findExitEdge(NodeList<CFG, Statement, Edge> body) {
            Edge exit = null;
            for (Edge out : this.target.getOutgoingEdges(this.conditional)) {
                if (out.getDestination() == this.conditional || body.containsNode(out.getDestination())) continue;
                exit = out;
                break;
            }
            return exit;
        }
    }
}

