/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.CodeMemberDescriptor;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.PluggableStatement;
import it.unive.lisa.program.cfg.statement.Statement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NativeCFG
implements CodeMember {
    private final CodeMemberDescriptor descriptor;
    private final Class<? extends NaryExpression> construct;

    public NativeCFG(CodeMemberDescriptor descriptor, Class<? extends NaryExpression> construct) {
        if (!PluggableStatement.class.isAssignableFrom(construct)) {
            throw new IllegalArgumentException(construct + " must implement the " + PluggableStatement.class.getName() + " to be used within native cfgs");
        }
        this.descriptor = descriptor;
        this.construct = construct;
    }

    @Override
    public CodeMemberDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    public NaryExpression rewrite(Statement original, Expression ... params) throws CallResolutionException {
        try {
            Method builder = this.construct.getDeclaredMethod("build", CFG.class, CodeLocation.class, Expression[].class);
            NaryExpression instance = (NaryExpression)builder.invoke(null, original.getCFG(), original.getLocation(), params);
            ((PluggableStatement)((Object)instance)).setOriginatingStatement(original);
            return instance;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CallResolutionException("Unable to create call to native construct " + this.construct.getName(), e);
        }
    }
}

