/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.VariableTableEntry;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CodeMemberDescriptor
implements CodeElement {
    private final Unit unit;
    private final String name;
    private final Parameter[] formals;
    private final Type returnType;
    private final List<VariableTableEntry> variables;
    private final boolean instance;
    private boolean overridable;
    private final Collection<CodeMember> overriddenBy;
    private final Collection<CodeMember> overrides;
    private final Annotations annotations;
    private final CodeLocation location;

    public CodeMemberDescriptor(CodeLocation location, Unit unit, boolean instance, String name, Parameter ... formals) {
        this(location, unit, instance, name, (Type)Untyped.INSTANCE, formals);
    }

    public CodeMemberDescriptor(CodeLocation location, Unit unit, boolean instance, String name, Type returnType, Parameter ... formals) {
        this(location, unit, instance, name, returnType, new Annotations(new Annotation[0]), formals);
    }

    public CodeMemberDescriptor(CodeLocation location, Unit unit, boolean instance, String name, Type returnType, Annotations annotations, Parameter ... formals) {
        int i;
        Objects.requireNonNull(unit, "The unit of a CFG cannot be null");
        Objects.requireNonNull(name, "The name of a CFG cannot be null");
        Objects.requireNonNull(formals, "The array of formal parameters of a CFG cannot be null");
        Objects.requireNonNull(returnType, "The return type of a CFG cannot be null");
        Objects.requireNonNull(location, "The location of a CFG cannot be null");
        for (i = 0; i < formals.length; ++i) {
            Objects.requireNonNull(formals[i], "The " + i + "-th formal parameter of a CFG cannot be null");
        }
        this.location = location;
        this.unit = unit;
        this.name = name;
        this.formals = formals;
        this.returnType = returnType;
        this.instance = instance;
        this.annotations = annotations;
        this.overridable = instance;
        this.overriddenBy = new HashSet<CodeMember>();
        this.overrides = new HashSet<CodeMember>();
        this.variables = new LinkedList<VariableTableEntry>();
        i = 0;
        for (Parameter formal : formals) {
            this.addVariable(new VariableTableEntry(formal.getLocation(), i++, null, null, formal.getName(), formal.getStaticType()));
        }
    }

    public boolean isInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.unit.getName() + "::" + this.getName();
    }

    public String getSignature() {
        Object[] types = new Type[this.formals.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.formals[i].getStaticType();
        }
        return this.getFullName() + "(" + StringUtils.join((Object[])types, (String)", ") + ")";
    }

    public String getSignatureWithParNames() {
        return this.getFullName() + "(" + StringUtils.join((Object[])this.formals, (String)", ") + ")";
    }

    public String getFullSignature() {
        return this.returnType + " " + this.getSignature();
    }

    public String getFullSignatureWithParNames() {
        return this.returnType + " " + this.getSignatureWithParNames();
    }

    public Parameter[] getFormals() {
        return this.formals;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<VariableTableEntry> getVariables() {
        return this.variables;
    }

    public void addVariable(VariableTableEntry variable) {
        if (variable.getIndex() != this.variables.size()) {
            variable.setIndex(this.variables.size());
        }
        this.variables.add(variable);
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean overridable) {
        this.overridable = overridable;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Collection<CodeMember> overriddenBy() {
        return this.overriddenBy;
    }

    public Collection<CodeMember> overrides() {
        return this.overrides;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + Arrays.hashCode(this.formals);
        result = 31 * result + (this.instance ? 1231 : 1237);
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.overridable ? 1231 : 1237);
        result = 31 * result + (this.overriddenBy == null ? 0 : this.overriddenBy.hashCode());
        result = 31 * result + (this.overrides == null ? 0 : this.overrides.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeMemberDescriptor other = (CodeMemberDescriptor)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (!Arrays.equals(this.formals, other.formals)) {
            return false;
        }
        if (this.instance != other.instance) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.overridable != other.overridable) {
            return false;
        }
        if (this.overriddenBy == null ? other.overriddenBy != null : !this.overriddenBy.equals(other.overriddenBy)) {
            return false;
        }
        if (this.overrides == null ? other.overrides != null : !this.overrides.equals(other.overrides)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }

    public String toString() {
        return this.getFullSignature() + " [at " + this.location + "]";
    }

    public boolean matchesSignature(CodeMemberDescriptor reference) {
        if (!this.name.equals(reference.name)) {
            return false;
        }
        if (this.formals.length != reference.formals.length) {
            return false;
        }
        for (int i = 0; i < this.formals.length; ++i) {
            if (this.formals[i].getStaticType().canBeAssignedTo(reference.formals[i].getStaticType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }
}

