/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.OptimizedAnalyzedCFG;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.conf.LiSAConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.outputs.serializableGraph.SerializableCFG;
import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.CodeMemberDescriptor;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowExtractor;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowStructure;
import it.unive.lisa.program.cfg.controlFlow.IfThenElse;
import it.unive.lisa.program.cfg.controlFlow.Loop;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.edge.SequentialEdge;
import it.unive.lisa.program.cfg.fixpoints.AscendingFixpoint;
import it.unive.lisa.program.cfg.fixpoints.BackwardAscendingFixpoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.fixpoints.DescendingGLBFixpoint;
import it.unive.lisa.program.cfg.fixpoints.DescendingNarrowingFixpoint;
import it.unive.lisa.program.cfg.fixpoints.OptimizedBackwardFixpoint;
import it.unive.lisa.program.cfg.fixpoints.OptimizedFixpoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NoOp;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.util.collections.workset.VisitOnceFIFOWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.BackwardFixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import it.unive.lisa.util.datastructures.graph.code.CodeGraph;
import it.unive.lisa.util.datastructures.graph.code.NodeList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CFG
extends CodeGraph<CFG, Statement, Edge>
implements CodeMember {
    private static final Logger LOG = LogManager.getLogger(CFG.class);
    private final CodeMemberDescriptor descriptor;
    private final Collection<ControlFlowStructure> cfStructs;
    private Map<Statement, Statement[]> basicBlocks;

    public CFG(CodeMemberDescriptor descriptor) {
        super(new SequentialEdge());
        this.descriptor = descriptor;
        this.cfStructs = new LinkedList<ControlFlowStructure>();
    }

    public CFG(CodeMemberDescriptor descriptor, Collection<Statement> entrypoints, NodeList<CFG, Statement, Edge> list) {
        super(entrypoints, list);
        this.descriptor = descriptor;
        this.cfStructs = new LinkedList<ControlFlowStructure>();
    }

    public CFG(CFG other) {
        super(other.entrypoints, other.list);
        this.descriptor = other.descriptor;
        this.cfStructs = other.cfStructs;
        this.basicBlocks = other.basicBlocks;
    }

    @Override
    public final CodeMemberDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Collection<Statement> getNormalExitpoints() {
        return this.list.getNodes().stream().filter(st -> st.stopsExecution() && !st.throwsError()).collect(Collectors.toList());
    }

    public Collection<Statement> getAllExitpoints() {
        return this.list.getNodes().stream().filter(st -> st.stopsExecution() || st.throwsError()).collect(Collectors.toList());
    }

    public void addControlFlowStructure(ControlFlowStructure cf) {
        if (this.cfStructs.stream().anyMatch(c -> c.getCondition().equals(cf.getCondition()))) {
            throw new IllegalArgumentException("Cannot have more than one conditional structure happening on the same condition: " + cf.getCondition());
        }
        this.cfStructs.add(cf);
    }

    public Collection<ControlFlowStructure> getControlFlowStructures() {
        return this.cfStructs;
    }

    public void extractControlFlowStructures(ControlFlowExtractor extractor) {
        LOG.debug("Extracting control flow structures from " + this);
        extractor.extract(this).forEach(this.cfStructs::add);
    }

    @Override
    public String toString() {
        return this.descriptor.toString();
    }

    public void simplify() {
        super.simplify(NoOp.class, new LinkedList(), new HashMap());
        this.cfStructs.forEach(ControlFlowStructure::simplify);
    }

    public <A extends AbstractState<A>> AnalyzedCFG<A> fixpoint(AnalysisState<A> entryState, InterproceduralAnalysis<A> interprocedural, WorkingSet<Statement> ws, FixpointConfiguration conf, ScopeId id) throws FixpointException {
        HashMap start = new HashMap();
        this.entrypoints.forEach(e -> start.put((Statement)e, entryState));
        return this.fixpoint(entryState, start, interprocedural, ws, conf, id);
    }

    public <A extends AbstractState<A>> AnalyzedCFG<A> fixpoint(Collection<Statement> entrypoints, AnalysisState<A> entryState, InterproceduralAnalysis<A> interprocedural, WorkingSet<Statement> ws, FixpointConfiguration conf, ScopeId id) throws FixpointException {
        HashMap start = new HashMap();
        entrypoints.forEach(e -> start.put((Statement)e, entryState));
        return this.fixpoint(entryState, start, interprocedural, ws, conf, id);
    }

    public <A extends AbstractState<A>> AnalyzedCFG<A> fixpoint(AnalysisState<A> singleton, Map<Statement, AnalysisState<A>> startingPoints, InterproceduralAnalysis<A> interprocedural, WorkingSet<Statement> ws, FixpointConfiguration conf, ScopeId id) throws FixpointException {
        Map<Statement, CFGFixpoint.CompoundState<A>> descending;
        boolean isOptimized = conf.optimize && conf.descendingPhaseType == LiSAConfiguration.DescendingPhaseType.NONE;
        Fixpoint fix = isOptimized ? new OptimizedFixpoint(this, false, conf.hotspots) : new Fixpoint(this, false);
        AscendingFixpoint<A> asc = new AscendingFixpoint<A>(this, interprocedural, conf);
        HashMap starting = new HashMap();
        StatementStore bot = new StatementStore(singleton.bottom());
        startingPoints.forEach((st, state) -> starting.put(st, CFGFixpoint.CompoundState.of(state, bot)));
        Map<Statement, CFGFixpoint.CompoundState<A>> ascending = fix.fixpoint(starting, ws, asc);
        if (conf.descendingPhaseType == LiSAConfiguration.DescendingPhaseType.NONE) {
            return this.flatten(isOptimized, singleton, startingPoints, interprocedural, id, ascending);
        }
        fix = conf.optimize ? new OptimizedFixpoint(this, true, conf.hotspots) : new Fixpoint(this, true);
        switch (conf.descendingPhaseType) {
            case GLB: {
                DescendingGLBFixpoint<A> dg = new DescendingGLBFixpoint<A>(this, interprocedural, conf);
                descending = fix.fixpoint(starting, ws, dg, ascending);
                break;
            }
            case NARROWING: {
                DescendingNarrowingFixpoint<A> dn = new DescendingNarrowingFixpoint<A>(this, interprocedural, conf);
                descending = fix.fixpoint(starting, ws, dn, ascending);
                break;
            }
            default: {
                descending = ascending;
            }
        }
        return this.flatten(conf.optimize, singleton, startingPoints, interprocedural, id, descending);
    }

    private <A extends AbstractState<A>> AnalyzedCFG<A> flatten(boolean isOptimized, AnalysisState<A> singleton, Map<Statement, AnalysisState<A>> startingPoints, InterproceduralAnalysis<A> interprocedural, ScopeId id, Map<Statement, CFGFixpoint.CompoundState<A>> fixpointResults) {
        HashMap finalResults = new HashMap(fixpointResults.size());
        for (Map.Entry<Statement, CFGFixpoint.CompoundState<A>> e : fixpointResults.entrySet()) {
            finalResults.put(e.getKey(), e.getValue().postState);
            for (Map.Entry entry : e.getValue().intermediateStates) {
                finalResults.put((Statement)entry.getKey(), (AnalysisState)entry.getValue());
            }
        }
        return isOptimized ? new OptimizedAnalyzedCFG<A>(this, id, singleton, startingPoints, finalResults, interprocedural) : new AnalyzedCFG<A>(this, id, singleton, startingPoints, finalResults);
    }

    public <A extends AbstractState<A>> AnalyzedCFG<A> backwardFixpoint(AnalysisState<A> exitState, InterproceduralAnalysis<A> interprocedural, WorkingSet<Statement> ws, FixpointConfiguration conf, ScopeId id) throws FixpointException {
        HashMap start = new HashMap();
        this.getAllExitpoints().forEach(e -> start.put((Statement)e, exitState));
        return this.backwardFixpoint(exitState, start, interprocedural, ws, conf, id);
    }

    public <A extends AbstractState<A>> AnalyzedCFG<A> backwardFixpoint(Collection<Statement> exitpoints, AnalysisState<A> exitState, InterproceduralAnalysis<A> interprocedural, WorkingSet<Statement> ws, FixpointConfiguration conf, ScopeId id) throws FixpointException {
        HashMap start = new HashMap();
        exitpoints.forEach(e -> start.put((Statement)e, exitState));
        return this.backwardFixpoint(exitState, start, interprocedural, ws, conf, id);
    }

    public <A extends AbstractState<A>> AnalyzedCFG<A> backwardFixpoint(AnalysisState<A> singleton, Map<Statement, AnalysisState<A>> startingPoints, InterproceduralAnalysis<A> interprocedural, WorkingSet<Statement> ws, FixpointConfiguration conf, ScopeId id) throws FixpointException {
        Map<Statement, CFGFixpoint.CompoundState<A>> descending;
        boolean isOptimized = conf.optimize && conf.descendingPhaseType == LiSAConfiguration.DescendingPhaseType.NONE;
        BackwardFixpoint fix = isOptimized ? new OptimizedBackwardFixpoint(this, false, conf.hotspots) : new BackwardFixpoint(this, false);
        BackwardAscendingFixpoint<A> asc = new BackwardAscendingFixpoint<A>(this, interprocedural, conf);
        HashMap starting = new HashMap();
        StatementStore bot = new StatementStore(singleton.bottom());
        startingPoints.forEach((st, state) -> starting.put(st, CFGFixpoint.CompoundState.of(state, bot)));
        Map<Statement, CFGFixpoint.CompoundState<A>> ascending = fix.fixpoint(starting, ws, asc);
        if (conf.descendingPhaseType == LiSAConfiguration.DescendingPhaseType.NONE) {
            return this.flatten(isOptimized, singleton, startingPoints, interprocedural, id, ascending);
        }
        fix = conf.optimize ? new OptimizedBackwardFixpoint(this, true, conf.hotspots) : new BackwardFixpoint(this, true);
        switch (conf.descendingPhaseType) {
            case GLB: {
                DescendingGLBFixpoint<A> dg = new DescendingGLBFixpoint<A>(this, interprocedural, conf);
                descending = fix.fixpoint(starting, ws, dg, ascending);
                break;
            }
            case NARROWING: {
                DescendingNarrowingFixpoint<A> dn = new DescendingNarrowingFixpoint<A>(this, interprocedural, conf);
                descending = fix.fixpoint(starting, ws, dn, ascending);
                break;
            }
            default: {
                descending = ascending;
            }
        }
        return this.flatten(conf.optimize, singleton, startingPoints, interprocedural, id, descending);
    }

    @Override
    public SerializableGraph toSerializableGraph(BiFunction<CFG, Statement, SerializableValue> descriptionGenerator) {
        return SerializableCFG.fromCFG(this, descriptionGenerator);
    }

    @Override
    public void preSimplify(Statement node) {
        this.shiftVariableScopes(node);
        this.shiftControlFlowStructuresEnd(node);
    }

    private void shiftControlFlowStructuresEnd(Statement node) {
        Collection<Statement> followers = this.followersOf(node);
        for (ControlFlowStructure cfs : this.cfStructs) {
            if (node != cfs.getFirstFollower()) continue;
            if (followers.isEmpty()) {
                cfs.setFirstFollower(null);
                continue;
            }
            if (followers.size() == 1) {
                Statement candidate = followers.iterator().next();
                if (!(candidate instanceof NoOp)) {
                    cfs.setFirstFollower(candidate);
                    continue;
                }
                cfs.setFirstFollower(this.firstNonNoOpDeterministicFollower(candidate));
                continue;
            }
            LOG.warn("{} is the first follower of a control flow structure, it is being simplified but has multiple followers: the first follower of the conditional structure will be lost", (Object)node);
            cfs.setFirstFollower(null);
        }
    }

    private Statement firstNonNoOpDeterministicFollower(Statement st) {
        Statement current = st;
        while (current instanceof NoOp) {
            Collection<Statement> followers = this.followersOf(current);
            if (followers.isEmpty() || followers.size() > 1) {
                return null;
            }
            current = followers.iterator().next();
        }
        return current;
    }

    private void shiftVariableScopes(Statement node) {
        Statement pred;
        Statement follow;
        Collection starting = this.descriptor.getVariables().stream().filter(v -> v.getScopeStart() == node).collect(Collectors.toList());
        Collection ending = this.descriptor.getVariables().stream().filter(v -> v.getScopeEnd() == node).collect(Collectors.toList());
        if (ending.isEmpty() && starting.isEmpty()) {
            return;
        }
        Collection<Statement> predecessors = this.predecessorsOf(node);
        Collection<Statement> followers = this.followersOf(node);
        if (predecessors.isEmpty() && followers.isEmpty()) {
            LOG.warn("Simplifying the only statement of '{}': all variables will be made visible for the entire cfg", (Object)this);
            starting.forEach(v -> v.setScopeStart(null));
            ending.forEach(v -> v.setScopeEnd(null));
            return;
        }
        String format = "Simplifying the scope-{} statement of a variable with {} is not supported: {} will be made visible {} of '" + this + "'";
        if (!starting.isEmpty()) {
            if (predecessors.isEmpty()) {
                if (followers.size() > 1) {
                    LOG.warn(format, (Object)"starting", (Object)"no predecessors and multiple followers", (Object)starting, (Object)"from the start");
                    follow = null;
                } else {
                    follow = followers.iterator().next();
                }
                starting.forEach(v -> v.setScopeStart(follow));
            } else {
                if (predecessors.size() > 1) {
                    LOG.warn(format, (Object)"starting", (Object)"multiple predecessors", (Object)starting, (Object)"from the start");
                    pred = null;
                } else {
                    pred = predecessors.iterator().next();
                }
                starting.forEach(v -> v.setScopeStart(pred));
            }
        }
        if (!ending.isEmpty()) {
            if (followers.isEmpty()) {
                if (predecessors.size() > 1) {
                    LOG.warn(format, (Object)"ending", (Object)"no followers and multiple predecessors", (Object)ending, (Object)"until the end");
                    pred = null;
                } else {
                    pred = predecessors.iterator().next();
                }
                ending.forEach(v -> v.setScopeEnd(pred));
            } else {
                if (followers.size() > 1) {
                    LOG.warn(format, (Object)"ending", (Object)"multiple followers", (Object)ending, (Object)"until the end");
                    follow = null;
                } else {
                    follow = followers.iterator().next();
                }
                ending.forEach(v -> v.setScopeEnd(follow));
            }
        }
    }

    public ProgramPoint getGenericProgramPoint() {
        return new ProgramPoint(){

            @Override
            public CFG getCFG() {
                return CFG.this;
            }

            public String toString() {
                return "unknown program point in " + CFG.this.getDescriptor().getSignature();
            }

            @Override
            public CodeLocation getLocation() {
                return SyntheticLocation.INSTANCE;
            }
        };
    }

    @Override
    public void validate() throws ProgramValidationException {
        try {
            this.list.validate(this.entrypoints);
        }
        catch (ProgramValidationException e) {
            throw new ProgramValidationException("The matrix behind " + this + " is invalid", e);
        }
        for (ControlFlowStructure struct : this.cfStructs) {
            for (Statement st : struct.allStatements()) {
                if ((st != null || struct.getFirstFollower() == null) && (st == null || this.list.containsNode(st))) continue;
                throw new ProgramValidationException(this + " has a conditional structure (" + struct + ") that contains a node not in the graph: " + st);
            }
        }
        for (Statement st : this.list) {
            Collection outs = this.list.getOutgoingEdges(st);
            if (st.stopsExecution() && !outs.isEmpty()) {
                throw new ProgramValidationException(this + " contains an execution-stopping node that has followers: " + st);
            }
            if (!outs.isEmpty() || st.stopsExecution() || st.throwsError()) continue;
            throw new ProgramValidationException(this + " contains a node with no followers that is not execution-stopping: " + st);
        }
        if (!this.list.getNodes().containsAll(this.entrypoints)) {
            throw new ProgramValidationException(this + " has entrypoints that are not part of the graph: " + new HashSet(this.entrypoints).retainAll(this.list.getNodes()));
        }
    }

    private Collection<ControlFlowStructure> getControlFlowsContaining(ProgramPoint pp) {
        if (!(pp instanceof Statement)) {
            return Collections.emptyList();
        }
        Statement st = (Statement)pp;
        if (st instanceof Call) {
            Call original = (Call)st;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != st) {
                st = original;
            }
        }
        if (st instanceof Expression) {
            st = ((Expression)st).getRootStatement();
        }
        LinkedList<ControlFlowStructure> res = new LinkedList<ControlFlowStructure>();
        for (ControlFlowStructure cf : this.cfStructs) {
            if (!cf.contains(st)) continue;
            res.add(cf);
        }
        return res;
    }

    public boolean isGuarded(ProgramPoint pp) {
        return !this.getControlFlowsContaining(pp).isEmpty();
    }

    public boolean isInsideLoop(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().anyMatch(Loop.class::isInstance);
    }

    public boolean isInsideIfThenElse(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().anyMatch(IfThenElse.class::isInstance);
    }

    public Collection<Statement> getGuards(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().map(ControlFlowStructure::getCondition).collect(Collectors.toList());
    }

    public Collection<Statement> getLoopGuards(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().filter(Loop.class::isInstance).map(ControlFlowStructure::getCondition).collect(Collectors.toList());
    }

    public Collection<Statement> getIfThenElseGuards(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().filter(IfThenElse.class::isInstance).map(ControlFlowStructure::getCondition).collect(Collectors.toList());
    }

    private Statement getRecent(ProgramPoint pp, Predicate<ControlFlowStructure> filter) {
        if (!(pp instanceof Statement)) {
            return null;
        }
        Statement st = (Statement)pp;
        Collection<ControlFlowStructure> cfs = this.getControlFlowsContaining(pp);
        Statement recent = null;
        int min = Integer.MAX_VALUE;
        for (ControlFlowStructure cf : cfs) {
            if (!filter.test(cf)) continue;
            if (recent == null) {
                recent = cf.getCondition();
                min = cf.distance(st);
                continue;
            }
            int m = cf.distance(st);
            if (m >= min && min != -1) continue;
            recent = cf.getCondition();
            min = m;
        }
        if (min == -1) {
            throw new IllegalStateException("Conditional flow structures containing " + pp + " could not evaluate the distance from the root of the structure to the statement itself");
        }
        return recent;
    }

    public Statement getMostRecentGuard(ProgramPoint pp) {
        return this.getRecent(pp, cf -> true);
    }

    public Statement getMostRecentLoopGuard(ProgramPoint pp) {
        return this.getRecent(pp, Loop.class::isInstance);
    }

    public Statement getMostRecentIfThenElseGuard(ProgramPoint pp) {
        return this.getRecent(pp, IfThenElse.class::isInstance);
    }

    public ControlFlowStructure getControlFlowStructureOf(ProgramPoint guard) {
        for (ControlFlowStructure struct : this.getControlFlowStructures()) {
            if (!struct.getCondition().equals(guard)) continue;
            return struct;
        }
        return null;
    }

    @Override
    public Collection<Statement> getCycleEntries() {
        HashSet<Statement> result = new HashSet<Statement>();
        for (ControlFlowStructure cfs : this.cfStructs) {
            if (!(cfs instanceof Loop)) continue;
            result.add(cfs.getCondition());
        }
        return result;
    }

    public void computeBasicBlocks() {
        HashSet<Statement> leaders = new HashSet<Statement>();
        leaders.addAll(this.entrypoints);
        for (ControlFlowStructure struct : this.cfStructs) {
            leaders.addAll(struct.getTargetedStatements());
        }
        this.basicBlocks = new IdentityHashMap<Statement, Statement[]>(leaders.size());
        for (Statement leader : leaders) {
            VisitOnceFIFOWorkingSet<Statement> ws = VisitOnceFIFOWorkingSet.mk();
            ws.push(leader);
            LinkedList<Statement> bb = new LinkedList<Statement>();
            while (!ws.isEmpty()) {
                Statement current = (Statement)ws.pop();
                bb.add(current);
                Collection<Statement> followers = this.list.followersOf(current);
                boolean pushed = false;
                for (Statement follower : followers) {
                    if (leaders.contains(follower)) continue;
                    if (pushed) {
                        throw new IllegalStateException("Cannot have statements with more than one follower inside a basic block");
                    }
                    ws.push(follower);
                    pushed = true;
                }
            }
            this.basicBlocks.put(leader, (Statement[])bb.toArray(Statement[]::new));
        }
    }

    public Map<Statement, Statement[]> getBasicBlocks() {
        if (this.basicBlocks == null) {
            throw new IllegalStateException("Cannot retrieve basic blocks before computing them");
        }
        return this.basicBlocks;
    }
}

