/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.annotations.values;

import it.unive.lisa.program.annotations.values.AnnotationValue;
import it.unive.lisa.program.annotations.values.BasicAnnotationValue;

public class FloatAnnotationValue
implements BasicAnnotationValue {
    private final float f;

    public FloatAnnotationValue(float f) {
        this.f = f;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.f);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatAnnotationValue other = (FloatAnnotationValue)obj;
        return Float.floatToIntBits(this.f) == Float.floatToIntBits(other.f);
    }

    public String toString() {
        return String.valueOf(this.f);
    }

    @Override
    public int compareTo(AnnotationValue o) {
        if (!(o instanceof FloatAnnotationValue)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        FloatAnnotationValue other = (FloatAnnotationValue)o;
        return Float.compare(this.f, other.f);
    }
}

