/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.annotations.values;

import it.unive.lisa.program.annotations.values.AnnotationValue;
import it.unive.lisa.program.annotations.values.BasicAnnotationValue;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ArrayAnnotationValue
implements AnnotationValue {
    private final BasicAnnotationValue[] arr;

    public ArrayAnnotationValue(BasicAnnotationValue[] arr) {
        this.arr = arr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arr);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayAnnotationValue other = (ArrayAnnotationValue)obj;
        return Arrays.equals(this.arr, other.arr);
    }

    public String toString() {
        return this.arr == null ? "[]" : "[" + StringUtils.join((Object[])this.arr, (String)", ") + "]";
    }

    @Override
    public int compareTo(AnnotationValue o) {
        if (!(o instanceof ArrayAnnotationValue)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        ArrayAnnotationValue other = (ArrayAnnotationValue)o;
        int cmp = Integer.compare(this.arr.length, other.arr.length);
        if (cmp != 0) {
            return cmp;
        }
        CollectionsDiffBuilder<BasicAnnotationValue> builder = new CollectionsDiffBuilder<BasicAnnotationValue>(BasicAnnotationValue.class, List.of(this.arr), List.of(other.arr));
        builder.compute(Comparable::compareTo);
        if (builder.sameContent()) {
            return 0;
        }
        return builder.getOnlyFirst().iterator().next().compareTo((AnnotationValue)builder.getOnlySecond().iterator().next());
    }
}

