/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.Global;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.CodeMemberDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class Unit {
    private final String name;
    private final Map<String, Global> globals;
    private final Map<String, CodeMember> codeMembers;

    protected Unit(String name) {
        this.name = name;
        this.globals = new TreeMap<String, Global>();
        this.codeMembers = new TreeMap<String, CodeMember>();
    }

    public final String getName() {
        return this.name;
    }

    public final Collection<Global> getGlobals() {
        return this.globals.values();
    }

    public final Collection<CodeMember> getCodeMembers() {
        return this.codeMembers.values();
    }

    public final Global getGlobal(String name) {
        return this.globals.get(name);
    }

    public final CodeMember getCodeMember(String signature) {
        return this.codeMembers.get(signature);
    }

    public final Collection<CodeMember> getCodeMembersByName(String name) {
        return this.codeMembers.values().stream().filter(c -> c.getDescriptor().getName().equals(name)).collect(Collectors.toList());
    }

    public Collection<Global> getGlobalsRecursively() {
        return new HashSet<Global>(this.getGlobals());
    }

    public Collection<CodeMember> getCodeMembersRecursively() {
        return new HashSet<CodeMember>(this.getCodeMembers());
    }

    public final boolean addGlobal(Global global) {
        return this.globals.putIfAbsent(global.getName(), global) == null;
    }

    public final boolean addCodeMember(CodeMember member) {
        return this.codeMembers.putIfAbsent(member.getDescriptor().getSignature(), member) == null;
    }

    public final String toString() {
        return this.name;
    }

    public final Collection<CodeMember> getMatchingCodeMember(CodeMemberDescriptor signature) {
        HashSet<CodeMember> result = new HashSet<CodeMember>();
        for (CodeMember member : this.codeMembers.values()) {
            if (!member.getDescriptor().matchesSignature(signature)) continue;
            result.add(member);
        }
        return result;
    }

    public abstract boolean canBeInstantiated();

    public abstract Program getProgram();
}

