/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.Global;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.language.LanguageFeatures;
import it.unive.lisa.type.TypeSystem;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Program
extends Unit {
    public static final String PROGRAM_NAME = "~LiSAProgram";
    private final Map<String, Unit> units;
    private final Collection<CFG> entrypoints;
    private final LanguageFeatures features;
    private final TypeSystem types;

    public Program(LanguageFeatures features, TypeSystem types) {
        super(PROGRAM_NAME);
        this.features = features;
        this.types = types;
        this.units = new TreeMap<String, Unit>();
        this.entrypoints = new LinkedList<CFG>();
    }

    public LanguageFeatures getFeatures() {
        return this.features;
    }

    public TypeSystem getTypes() {
        return this.types;
    }

    public final boolean addUnit(Unit unit) {
        if (unit instanceof Program) {
            throw new IllegalArgumentException("Cannot add a program to another one");
        }
        return this.units.putIfAbsent(unit.getName(), unit) == null;
    }

    public final boolean addEntryPoint(CFG cm) {
        return this.entrypoints.add(cm);
    }

    public final Collection<CFG> getEntryPoints() {
        return this.entrypoints;
    }

    public final Collection<Unit> getUnits() {
        return this.units.values();
    }

    public final Unit getUnit(String name) {
        return this.units.get(name);
    }

    @Override
    public Collection<CodeMember> getCodeMembersRecursively() {
        Collection<CodeMember> all = super.getCodeMembersRecursively();
        this.units.values().stream().flatMap(u -> u.getCodeMembersRecursively().stream()).forEach(all::add);
        return all;
    }

    @Override
    public Collection<Global> getGlobalsRecursively() {
        Collection<Global> all = super.getGlobalsRecursively();
        this.units.values().stream().flatMap(u -> u.getGlobalsRecursively().stream()).forEach(all::add);
        return all;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public Program getProgram() {
        return this;
    }

    public Collection<CFG> getAllCFGs() {
        return this.getCodeMembersRecursively().stream().filter(CFG.class::isInstance).map(CFG.class::cast).collect(Collectors.toSet());
    }
}

