/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CodeLocation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class InterfaceUnit
extends CompilationUnit {
    private final List<InterfaceUnit> superinterfaces = new LinkedList<InterfaceUnit>();

    public InterfaceUnit(CodeLocation location, Program program, String name, boolean sealed) {
        super(location, program, name, sealed);
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    public boolean addSuperinterface(InterfaceUnit unit) {
        return this.superinterfaces.add(unit);
    }

    @Override
    public Collection<CompilationUnit> getImmediateAncestors() {
        return this.superinterfaces.stream().map(CompilationUnit.class::cast).collect(Collectors.toList());
    }

    @Override
    public void addInstance(Unit unit) throws ProgramValidationException {
        if (this.superinterfaces.contains(unit)) {
            throw new ProgramValidationException("Found loop in compilation units hierarchy: " + unit + " is both a super unit and an instance of " + this);
        }
        this.instances.add(unit);
        for (InterfaceUnit sup : this.superinterfaces) {
            sup.addInstance(unit);
        }
    }

    @Override
    public boolean isInstanceOf(CompilationUnit unit) {
        return this == unit || unit.instances.contains(this) || this.superinterfaces.stream().anyMatch(u -> u.isInstanceOf(unit));
    }

    @Override
    public boolean addAncestor(CompilationUnit unit) {
        if (unit instanceof InterfaceUnit) {
            return this.superinterfaces.add((InterfaceUnit)unit);
        }
        return false;
    }
}

