/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Objects;

public class Global
implements CodeElement {
    private final String name;
    private final Type staticType;
    private final CodeLocation location;
    private final Annotations annotations;
    private final boolean isInstance;
    private final Unit container;

    public Global(CodeLocation location, Unit container, String name, boolean isInstance) {
        this(location, container, name, isInstance, Untyped.INSTANCE);
    }

    public Global(CodeLocation location, Unit container, String name, boolean isInstance, Type staticType) {
        this(location, container, name, isInstance, staticType, new Annotations(new Annotation[0]));
    }

    public Global(CodeLocation location, Unit container, String name, boolean isInstance, Type staticType, Annotations annotations) {
        Objects.requireNonNull(name, "The name of a global cannot be null");
        Objects.requireNonNull(staticType, "The type of a global cannot be null");
        Objects.requireNonNull(location, "The location of a global cannot be null");
        Objects.requireNonNull(container, "The container of a global cannot be null");
        this.location = location;
        this.name = name;
        this.staticType = staticType;
        this.annotations = annotations;
        this.container = container;
        this.isInstance = isInstance;
    }

    public String getName() {
        return this.name;
    }

    public Type getStaticType() {
        return this.staticType;
    }

    public Unit getContainer() {
        return this.container;
    }

    public boolean isInstance() {
        return this.isInstance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.isInstance ? 1231 : 1237);
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Global other = (Global)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        if (this.isInstance != other.isInstance) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType));
    }

    public String toString() {
        return this.staticType + " " + this.container.getName() + "#" + this.name;
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }

    public Variable toSymbolicVariable(CodeLocation where) {
        return new Variable(this.staticType, this.name, this.annotations, where);
    }
}

