/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.Global;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.value.Constant;
import java.util.Objects;

public class ConstantGlobal
extends Global {
    private final Constant constant;

    public ConstantGlobal(CodeLocation location, Unit container, String name, Constant constant) {
        this(location, container, name, constant, new Annotations(new Annotation[0]));
    }

    public ConstantGlobal(CodeLocation location, Unit container, String name, Constant constant, Annotations annotations) {
        super(location, container, name, false, constant.getStaticType(), annotations);
        Objects.requireNonNull(constant, "The constant of a constant global cannot be null");
        this.constant = constant;
    }

    public Constant getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.constant == null ? 0 : this.constant.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantGlobal other = (ConstantGlobal)obj;
        return !(this.constant == null ? other.constant != null : !this.constant.equals(other.constant));
    }

    @Override
    public String toString() {
        return "const " + super.toString() + " = " + this.constant;
    }
}

