/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.Global;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramUnit;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.AbstractCodeMember;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.CodeMemberDescriptor;
import it.unive.lisa.program.cfg.NativeCFG;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;

public abstract class CompilationUnit
extends ProgramUnit {
    private final Map<String, Global> instanceGlobals;
    private final Map<String, CodeMember> instanceCodeMembers;
    protected final Collection<Unit> instances;
    private final Annotations annotations;
    private final boolean sealed;

    protected CompilationUnit(CodeLocation location, Program program, String name, boolean sealed) {
        super(location, program, name);
        this.sealed = sealed;
        this.instanceCodeMembers = new TreeMap<String, CodeMember>();
        this.instanceGlobals = new TreeMap<String, Global>();
        this.instances = new HashSet<Unit>();
        this.annotations = new Annotations(new Annotation[0]);
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public abstract boolean addAncestor(CompilationUnit var1);

    public abstract void addInstance(Unit var1) throws ProgramValidationException;

    @Override
    public Collection<CodeMember> getCodeMembersRecursively() {
        Collection<CodeMember> all = super.getCodeMembersRecursively();
        this.instanceCodeMembers.values().forEach(all::add);
        return all;
    }

    @Override
    public Collection<Global> getGlobalsRecursively() {
        Collection<Global> all = super.getGlobalsRecursively();
        this.instanceGlobals.values().forEach(all::add);
        return all;
    }

    public Collection<CodeMember> getInstanceCodeMembers(boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> true, traverseHierarchy);
    }

    public Collection<Global> getInstanceGlobals(boolean traverseHierarchy) {
        return this.searchGlobals(g -> true, traverseHierarchy);
    }

    public Collection<CFG> getInstanceCFGs(boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm instanceof CFG, traverseHierarchy);
    }

    public Collection<AbstractCodeMember> getAbstractCodeMembers(boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm instanceof AbstractCodeMember, traverseHierarchy);
    }

    public Collection<NativeCFG> getInstanceConstructs(boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm instanceof NativeCFG, traverseHierarchy);
    }

    public Collection<Unit> getInstances() {
        return this.instances;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }

    public abstract Collection<CompilationUnit> getImmediateAncestors();

    public abstract boolean isInstanceOf(CompilationUnit var1);

    public <T extends CodeMember> Collection<T> searchCodeMembers(Predicate<CodeMember> filter, boolean traverseHierarchy) {
        HashSet<CodeMember> result = new HashSet<CodeMember>();
        for (CodeMember member : this.instanceCodeMembers.values()) {
            if (!filter.test(member)) continue;
            result.add(member);
        }
        if (!traverseHierarchy) {
            return result;
        }
        for (CompilationUnit cu : this.getImmediateAncestors()) {
            for (CodeMember sup : cu.searchCodeMembers(filter, true)) {
                if (result.stream().anyMatch(cm -> sup.getDescriptor().overriddenBy().contains(cm))) continue;
                result.add(sup);
            }
        }
        return result;
    }

    public Collection<Global> searchGlobals(Predicate<Global> filter, boolean traverseHierarchy) {
        HashMap<String, Global> result = new HashMap<String, Global>();
        for (Global g : this.instanceGlobals.values()) {
            if (!filter.test(g)) continue;
            result.put(g.getName(), g);
        }
        if (!traverseHierarchy) {
            return result.values();
        }
        for (CompilationUnit cu : this.getImmediateAncestors()) {
            for (Global sup : cu.searchGlobals(filter, true)) {
                if (result.containsKey(sup.getName())) continue;
                result.put(sup.getName(), sup);
            }
        }
        return result.values();
    }

    public boolean addInstanceGlobal(Global global) {
        return this.instanceGlobals.putIfAbsent(global.getName(), global) == null;
    }

    public boolean addInstanceCodeMember(CodeMember cm) {
        CodeMember c = this.instanceCodeMembers.putIfAbsent(cm.getDescriptor().getSignature(), cm);
        if (this.sealed) {
            if (c == null) {
                cm.getDescriptor().setOverridable(false);
            } else {
                c.getDescriptor().setOverridable(false);
            }
        }
        return c == null;
    }

    public CodeMember getInstanceCodeMember(String signature, boolean traverseHierarchy) {
        Collection res = this.searchCodeMembers(cm -> cm.getDescriptor().getSignature().equals(signature), traverseHierarchy);
        if (res.isEmpty()) {
            return null;
        }
        return (CodeMember)res.stream().findFirst().get();
    }

    public Global getInstanceGlobal(String name, boolean traverseHierarchy) {
        Collection<Global> res = this.searchGlobals(cm -> cm.getName().equals(name), traverseHierarchy);
        if (res.isEmpty()) {
            return null;
        }
        return res.stream().findFirst().get();
    }

    public Collection<CodeMember> getInstanceCodeMembersByName(String name, boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm.getDescriptor().getName().equals(name), traverseHierarchy);
    }

    public Collection<CodeMember> getMatchingInstanceCodeMembers(CodeMemberDescriptor signature, boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm.getDescriptor().matchesSignature(signature), traverseHierarchy);
    }
}

