/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.InterfaceUnit;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CodeLocation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class ClassUnit
extends CompilationUnit {
    private final List<ClassUnit> superclasses;
    private final List<InterfaceUnit> interfaces;

    public ClassUnit(CodeLocation location, Program program, String name, boolean sealed) {
        super(location, program, name, sealed);
        Objects.requireNonNull(location, "The location of a unit cannot be null.");
        this.superclasses = new LinkedList<ClassUnit>();
        this.interfaces = new LinkedList<InterfaceUnit>();
    }

    @Override
    public Collection<CompilationUnit> getImmediateAncestors() {
        return CollectionUtils.union(this.superclasses, this.interfaces);
    }

    public List<ClassUnit> getSuperclasses() {
        return this.superclasses;
    }

    public List<InterfaceUnit> getInterfaces() {
        return this.interfaces;
    }

    public final boolean addSuperclass(ClassUnit unit) {
        return this.superclasses.add(unit);
    }

    public final boolean addInterface(InterfaceUnit unit) {
        return this.interfaces.add(unit);
    }

    @Override
    public boolean isInstanceOf(CompilationUnit unit) {
        return this == unit || unit.instances.contains(this) || this.getImmediateAncestors().stream().anyMatch(u -> u.isInstanceOf(unit));
    }

    @Override
    public void addInstance(Unit unit) throws ProgramValidationException {
        if (this.superclasses.contains(unit) || this.interfaces.contains(unit)) {
            throw new ProgramValidationException("Found loop in compilation units hierarchy: " + unit + " is both an ancestor and an instance of " + this);
        }
        this.instances.add(unit);
        for (ClassUnit classUnit : this.superclasses) {
            classUnit.addInstance(unit);
        }
        for (InterfaceUnit interfaceUnit : this.interfaces) {
            interfaceUnit.addInstance(unit);
        }
    }

    @Override
    public boolean canBeInstantiated() {
        return true;
    }

    @Override
    public boolean addAncestor(CompilationUnit unit) {
        if (unit instanceof ClassUnit) {
            return this.superclasses.add((ClassUnit)unit);
        }
        return this.interfaces.add((InterfaceUnit)unit);
    }
}

