/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import java.util.Collection;
import java.util.HashSet;

public class Application {
    private final Program[] programs;
    private Collection<CodeMember> members;
    private Collection<CFG> cfgs;
    private Collection<CFG> entrypoints;

    public Application(Program ... programs) {
        this.programs = programs;
    }

    public Program[] getPrograms() {
        return this.programs;
    }

    public Collection<CFG> getAllCFGs() {
        if (this.cfgs != null) {
            return this.cfgs;
        }
        this.cfgs = new HashSet<CFG>();
        for (Program p : this.programs) {
            this.cfgs.addAll(p.getAllCFGs());
        }
        return this.cfgs;
    }

    public Collection<CFG> getEntryPoints() {
        if (this.entrypoints != null) {
            return this.entrypoints;
        }
        this.entrypoints = new HashSet<CFG>();
        for (Program p : this.programs) {
            this.entrypoints.addAll(p.getEntryPoints());
        }
        return this.entrypoints;
    }

    public Collection<CodeMember> getAllCodeCodeMembers() {
        if (this.members != null) {
            return this.members;
        }
        this.members = new HashSet<CodeMember>();
        for (Program p : this.programs) {
            this.members.addAll(p.getCodeMembersRecursively());
        }
        return this.members;
    }
}

