/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableString;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class ValueDeserializer
extends StdDeserializer<SerializableValue> {
    private static final long serialVersionUID = -5817422267160292909L;

    public ValueDeserializer() {
        this(null);
    }

    public ValueDeserializer(Class<SerializableValue> t) {
        super(t);
    }

    public SerializableValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode props = node.get("lisaproperties");
        TreeMap<String, String> properties = new TreeMap<String, String>();
        if (props != null) {
            Iterator fields = props.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                properties.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
            }
            JsonNode arr = node.get("elements");
            JsonNode obj = node.get("fields");
            JsonNode str = node.get("value");
            if (str != null && arr == null && obj == null) {
                return new SerializableString(properties, str.asText());
            }
            if (str == null && arr != null && obj == null) {
                Iterator elements = arr.elements();
                LinkedList<SerializableValue> list = new LinkedList<SerializableValue>();
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    list.add((SerializableValue)ctxt.readValue(element.traverse(p.getCodec()), SerializableValue.class));
                }
                return new SerializableArray(properties, list);
            }
            if (str == null && arr == null && obj != null) {
                Iterator objFields = obj.fields();
                TreeMap<String, SerializableValue> map = new TreeMap<String, SerializableValue>();
                while (objFields.hasNext()) {
                    Map.Entry objField = (Map.Entry)objFields.next();
                    map.put((String)objField.getKey(), (SerializableValue)ctxt.readValue(((JsonNode)objField.getValue()).traverse(p.getCodec()), SerializableValue.class));
                }
                return new SerializableObject(properties, map);
            }
            throw new IllegalArgumentException("Node type not supported");
        }
        switch (node.getNodeType()) {
            case ARRAY: {
                Iterator elements = node.elements();
                LinkedList<SerializableValue> list = new LinkedList<SerializableValue>();
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    list.add((SerializableValue)ctxt.readValue(element.traverse(p.getCodec()), SerializableValue.class));
                }
                return new SerializableArray(properties, list);
            }
            case OBJECT: {
                Iterator objFields = node.fields();
                TreeMap<String, SerializableValue> map = new TreeMap<String, SerializableValue>();
                while (objFields.hasNext()) {
                    Map.Entry objField = (Map.Entry)objFields.next();
                    map.put((String)objField.getKey(), (SerializableValue)ctxt.readValue(((JsonNode)objField.getValue()).traverse(p.getCodec()), SerializableValue.class));
                }
                return new SerializableObject(properties, map);
            }
            case STRING: {
                return new SerializableString(properties, node.asText());
            }
        }
        throw new IllegalArgumentException("Node type not supported: " + node.getNodeType());
    }
}

