/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import it.unive.lisa.outputs.serializableGraph.ValueDeserializer;
import it.unive.lisa.outputs.serializableGraph.ValueSerializer;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonSerialize(using=ValueSerializer.class)
@JsonDeserialize(using=ValueDeserializer.class)
public abstract class SerializableValue
implements Comparable<SerializableValue> {
    private final SortedMap<String, String> properties;

    protected SerializableValue() {
        this.properties = new TreeMap<String, String>();
    }

    protected SerializableValue(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @JsonIgnore
    public abstract Collection<SerializableValue> getInnerValues();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableValue other = (SerializableValue)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public int compareTo(SerializableValue o) {
        int cmp = Integer.compare(this.properties.keySet().size(), o.properties.keySet().size());
        if (cmp != 0) {
            return cmp;
        }
        CollectionsDiffBuilder<String> builder = new CollectionsDiffBuilder<String>(String.class, this.properties.keySet(), o.properties.keySet());
        builder.compute(String::compareTo);
        if (!builder.sameContent()) {
            return builder.getOnlyFirst().iterator().next().compareTo(builder.getOnlySecond().iterator().next());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            cmp = entry.getValue().compareTo((String)o.properties.get(entry.getKey()));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

