/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SerializableObject
extends SerializableValue {
    private final SortedMap<String, SerializableValue> fields;

    public SerializableObject() {
        this.fields = new TreeMap<String, SerializableValue>();
    }

    public SerializableObject(SortedMap<String, String> properties, SortedMap<String, SerializableValue> fields) {
        super(properties);
        this.fields = fields;
    }

    public SortedMap<String, SerializableValue> getFields() {
        return this.fields;
    }

    @Override
    public Collection<SerializableValue> getInnerValues() {
        HashSet<SerializableValue> result = new HashSet<SerializableValue>(this.fields.values());
        for (SerializableValue inner : this.fields.values()) {
            result.addAll(inner.getInnerValues());
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableObject other = (SerializableObject)obj;
        return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, SerializableValue> entry : this.fields.entrySet()) {
            builder.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return "{ " + builder.toString() + " }";
    }

    @Override
    public int compareTo(SerializableValue o) {
        if (!(o instanceof SerializableObject)) {
            return 1;
        }
        SerializableObject other = (SerializableObject)o;
        int cmp = Integer.compare(this.fields.keySet().size(), other.fields.keySet().size());
        if (cmp != 0) {
            return cmp;
        }
        CollectionsDiffBuilder<String> builder = new CollectionsDiffBuilder<String>(String.class, this.fields.keySet(), other.fields.keySet());
        builder.compute(String::compareTo);
        if (!builder.sameContent()) {
            return builder.getOnlyFirst().iterator().next().compareTo(builder.getOnlySecond().iterator().next());
        }
        for (Map.Entry<String, SerializableValue> entry : this.fields.entrySet()) {
            cmp = entry.getValue().compareTo((SerializableValue)other.fields.get(entry.getKey()));
            if (cmp == 0) continue;
            return cmp;
        }
        return super.compareTo(o);
    }
}

