/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import it.unive.lisa.util.collections.CollectionUtilities;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SerializableNode
implements Comparable<SerializableNode> {
    private final int id;
    private final List<Integer> subNodes;
    private final String text;
    private final Map<String, String> unknownFields;

    public SerializableNode() {
        this(-1, Collections.emptyList(), null);
    }

    public SerializableNode(int id, List<Integer> subNodes, String text) {
        this.id = id;
        this.subNodes = subNodes;
        this.text = text;
        this.unknownFields = new TreeMap<String, String>();
    }

    public int getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Integer> getSubNodes() {
        return this.subNodes;
    }

    public String getText() {
        return this.text;
    }

    @JsonAnyGetter
    public Map<String, String> otherFields() {
        return this.unknownFields;
    }

    @JsonAnySetter
    public void setOtherField(String name, String value) {
        this.unknownFields.put(name, value);
    }

    @Override
    public int compareTo(SerializableNode o) {
        int cmp = Integer.compare(this.id, o.id);
        if (cmp != 0) {
            return cmp;
        }
        cmp = CollectionUtilities.nullSafeCompare(true, this.text, o.text, String::compareTo);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.subNodes.size() - o.subNodes.size();
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.subNodes.size(); ++i) {
            cmp = this.subNodes.get(i) - o.subNodes.get(i);
            if (cmp == 0) continue;
            return cmp;
        }
        cmp = Integer.compare(this.unknownFields.keySet().size(), o.unknownFields.keySet().size());
        if (cmp != 0) {
            return cmp;
        }
        CollectionsDiffBuilder<String> builder = new CollectionsDiffBuilder<String>(String.class, this.unknownFields.keySet(), o.unknownFields.keySet());
        builder.compute(String::compareTo);
        if (!builder.sameContent()) {
            return builder.getOnlyFirst().iterator().next().compareTo(builder.getOnlySecond().iterator().next());
        }
        for (Map.Entry<String, String> entry : this.unknownFields.entrySet()) {
            cmp = entry.getValue().compareTo(o.unknownFields.get(entry.getKey()));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.subNodes == null ? 0 : this.subNodes.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.unknownFields == null ? 0 : this.unknownFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableNode other = (SerializableNode)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.subNodes == null ? other.subNodes != null : !this.subNodes.equals(other.subNodes)) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.unknownFields == null ? other.unknownFields != null : !this.unknownFields.equals(other.unknownFields));
    }

    public String toString() {
        return this.id + "(" + this.subNodes + "):" + this.text;
    }
}

