/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import it.unive.lisa.outputs.DotGraph;
import it.unive.lisa.outputs.GraphmlGraph;
import it.unive.lisa.outputs.HtmlGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableEdge;
import it.unive.lisa.outputs.serializableGraph.SerializableNode;
import it.unive.lisa.outputs.serializableGraph.SerializableNodeDescription;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class SerializableGraph {
    private final String name;
    private final String description;
    private final SortedSet<SerializableNode> nodes;
    private final SortedSet<SerializableEdge> edges;
    private final SortedSet<SerializableNodeDescription> descriptions;

    public SerializableGraph() {
        this(null, null, new TreeSet<SerializableNode>(), new TreeSet<SerializableEdge>(), new TreeSet<SerializableNodeDescription>());
    }

    public SerializableGraph(String name, String description, SortedSet<SerializableNode> nodes, SortedSet<SerializableEdge> edges, SortedSet<SerializableNodeDescription> descriptions) {
        this.name = name;
        this.description = description;
        this.nodes = nodes;
        this.edges = edges;
        this.descriptions = descriptions;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SortedSet<SerializableNode> getNodes() {
        return this.nodes;
    }

    public SortedSet<SerializableEdge> getEdges() {
        return this.edges;
    }

    public SortedSet<SerializableNodeDescription> getDescriptions() {
        return this.descriptions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.descriptions == null ? 0 : this.descriptions.hashCode());
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableGraph other = (SerializableGraph)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.descriptions == null ? other.descriptions != null : !this.descriptions.equals(other.descriptions)) {
            return false;
        }
        if (this.edges == null ? other.edges != null : !this.edges.equals(other.edges)) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public String toString() {
        return "graph [name=" + this.name + ", description=" + this.description + "]";
    }

    public void dump(Writer writer) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, System.getProperty("lisa.json.indent") != null);
        mapper.writeValue(writer, (Object)this);
    }

    public void addNode(SerializableNode node) {
        if (this.nodes.stream().map(n -> n.getId()).anyMatch(i -> i.intValue() == node.getId())) {
            throw new IllegalArgumentException("A node with the same id " + node.getId() + " is already in the graph");
        }
        this.nodes.add(node);
    }

    public void addNodeDescription(SerializableNodeDescription desc) {
        if (this.descriptions.stream().map(d -> d.getNodeId()).anyMatch(i -> i.intValue() == desc.getNodeId())) {
            throw new IllegalArgumentException("A description for node " + desc.getNodeId() + " is already in the graph");
        }
        this.descriptions.add(desc);
    }

    public void addEdge(SerializableEdge edge) {
        this.edges.add(edge);
    }

    public DotGraph toDot() {
        DotGraph graph = new DotGraph(this.name);
        HashSet hasFollows = new HashSet();
        HashSet hasPreds = new HashSet();
        HashSet inners = new HashSet();
        HashMap labels = new HashMap();
        this.edges.forEach(e -> {
            hasFollows.add(e.getSourceId());
            hasPreds.add(e.getDestId());
        });
        this.descriptions.forEach(d -> labels.put(d.getNodeId(), d.getDescription()));
        this.nodes.forEach(n -> inners.addAll(n.getSubNodes()));
        for (SerializableNode n2 : this.nodes) {
            if (inners.contains(n2.getId())) continue;
            graph.addNode(n2, !hasPreds.contains(n2.getId()), !hasFollows.contains(n2.getId()), (SerializableValue)labels.get(n2.getId()));
        }
        for (SerializableEdge e2 : this.edges) {
            graph.addEdge(e2);
        }
        return graph;
    }

    public GraphmlGraph toGraphml(boolean includeSubnodes) {
        GraphmlGraph graph = new GraphmlGraph(this.name);
        HashSet hasFollows = new HashSet();
        HashSet hasPreds = new HashSet();
        HashSet rootnodes = new HashSet();
        HashMap containers = new HashMap();
        HashMap nodemap = new HashMap();
        HashMap labels = new HashMap();
        this.edges.forEach(e -> {
            hasFollows.add(e.getSourceId());
            hasPreds.add(e.getDestId());
        });
        this.descriptions.forEach(d -> labels.put(d.getNodeId(), d.getDescription()));
        this.nodes.forEach(n -> nodemap.put(n.getId(), n));
        rootnodes.addAll(nodemap.keySet());
        this.nodes.forEach(n -> {
            n.getSubNodes().forEach(sub -> containers.put((SerializableNode)nodemap.get(sub), n));
            rootnodes.removeAll(n.getSubNodes());
        });
        for (SerializableNode n2 : this.nodes) {
            if (!includeSubnodes && !rootnodes.contains(n2.getId())) continue;
            graph.addNode(n2, !hasPreds.contains(n2.getId()) && rootnodes.contains(n2.getId()), !hasFollows.contains(n2.getId()) && rootnodes.contains(n2.getId()), (SerializableValue)labels.get(n2.getId()));
        }
        if (includeSubnodes) {
            while (!containers.isEmpty()) {
                Set<Map.Entry> leaves = containers.entrySet().stream().filter(entry -> !containers.containsValue(entry.getKey())).collect(Collectors.toSet());
                leaves.forEach(entry -> {
                    graph.markSubNode((SerializableNode)entry.getValue(), (SerializableNode)entry.getKey());
                    containers.remove(entry.getKey());
                });
            }
        }
        for (SerializableEdge e2 : this.edges) {
            if (!includeSubnodes && (!rootnodes.contains(e2.getSourceId()) || !rootnodes.contains(e2.getDestId()))) continue;
            graph.addEdge(e2);
        }
        return graph;
    }

    public HtmlGraph toHtml(boolean includeSubnodes, String descriptionLabel) {
        SerializableGraph g = new SerializableGraph(this.name, this.description, this.nodes, this.edges, Collections.emptySortedSet());
        GraphmlGraph graphml = g.toGraphml(includeSubnodes);
        TreeMap<Integer, Pair<String, SerializableNodeDescription>> map = new TreeMap<Integer, Pair<String, SerializableNodeDescription>>();
        block0: for (SerializableNodeDescription d : this.descriptions) {
            for (SerializableNode n : this.nodes) {
                if (d.getNodeId() != n.getId()) continue;
                map.put(n.getId(), (Pair<String, SerializableNodeDescription>)Pair.of((Object)n.getText(), (Object)d));
                continue block0;
            }
        }
        return new HtmlGraph(graphml, includeSubnodes, map, this.description, descriptionLabel);
    }

    public static SerializableGraph readGraph(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (SerializableGraph)mapper.readValue(reader, SerializableGraph.class);
    }

    public boolean sameStructure(SerializableGraph other) {
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.edges == null ? other.edges != null : !this.edges.equals(other.edges)) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }
}

