/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.outputs.serializableGraph.SerializableEdge;
import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableNode;
import it.unive.lisa.outputs.serializableGraph.SerializableNodeDescription;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.NaryStatement;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class SerializableCFG {
    private SerializableCFG() {
    }

    public static SerializableGraph fromCFG(CFG source) {
        return SerializableCFG.fromCFG(source, null);
    }

    public static SerializableGraph fromCFG(CFG source, BiFunction<CFG, Statement, SerializableValue> descriptionGenerator) {
        String name = source.getDescriptor().getFullSignatureWithParNames();
        String desc = source instanceof AnalyzedCFG && !((AnalyzedCFG)source).getId().isStartingId() ? ((AnalyzedCFG)source).getId().toString() : null;
        TreeSet<SerializableNode> nodes = new TreeSet<SerializableNode>();
        TreeSet<SerializableNodeDescription> descrs = new TreeSet<SerializableNodeDescription>();
        TreeSet<SerializableEdge> edges = new TreeSet<SerializableEdge>();
        OffsetGenerator gen = new OffsetGenerator();
        source.accept(gen, null);
        for (Statement node : source.getNodes()) {
            SerializableCFG.process(source, nodes, descrs, node, descriptionGenerator, gen.result);
        }
        for (Edge edge : source.getEdges()) {
            edges.add(new SerializableEdge((Integer)gen.result.get(edge.getSource()).getLeft(), (Integer)gen.result.get(edge.getDestination()).getLeft(), edge.getClass().getSimpleName()));
        }
        return new SerializableGraph(name, desc, nodes, edges, descrs);
    }

    private static void process(CFG source, SortedSet<SerializableNode> nodes, SortedSet<SerializableNodeDescription> descrs, Statement node, BiFunction<CFG, Statement, SerializableValue> descriptionGenerator, Map<Statement, Pair<Integer, List<Statement>>> mapping) {
        Pair<Integer, List<Statement>> p = mapping.get(node);
        for (Statement inner : (List)p.getRight()) {
            SerializableCFG.process(source, nodes, descrs, inner, descriptionGenerator, mapping);
        }
        List<Integer> innerIds = ((List)p.getValue()).stream().map(st -> (Integer)((Pair)mapping.get(st)).getKey()).collect(Collectors.toList());
        SerializableCFG.addNode(source, nodes, descrs, node, (Integer)p.getKey(), innerIds, descriptionGenerator);
    }

    private static void addNode(CFG source, SortedSet<SerializableNode> nodes, SortedSet<SerializableNodeDescription> descrs, Statement node, Integer offset, List<Integer> inners, BiFunction<CFG, Statement, SerializableValue> descriptionGenerator) {
        SerializableValue value;
        SerializableNode n = new SerializableNode(offset, inners, node.toString());
        nodes.add(n);
        if (descriptionGenerator != null && (value = descriptionGenerator.apply(source, node)) != null) {
            descrs.add(new SerializableNodeDescription(offset, value));
        }
    }

    private static class OffsetGenerator
    implements GraphVisitor<CFG, Statement, Edge, Void> {
        private int offset = 0;
        private Map<Statement, Pair<Integer, List<Statement>>> result = new IdentityHashMap<Statement, Pair<Integer, List<Statement>>>();

        private OffsetGenerator() {
        }

        @Override
        public boolean visitSubNodesFirst() {
            return false;
        }

        @Override
        public boolean visit(Void tool, CFG graph, Statement node) {
            LinkedList<Expression> inners = new LinkedList<Expression>();
            if (node instanceof NaryStatement) {
                inners.addAll(Arrays.asList(((NaryStatement)node).getSubExpressions()));
            } else if (node instanceof NaryExpression) {
                inners.addAll(Arrays.asList(((NaryExpression)node).getSubExpressions()));
            }
            this.result.put(node, (Pair<Integer, List<Statement>>)Pair.of((Object)this.offset++, inners));
            return true;
        }
    }
}

