/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.serializableGraph;

import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableString;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;

public class SerializableArray
extends SerializableValue {
    private final List<SerializableValue> elements;

    public SerializableArray() {
        this.elements = new LinkedList<SerializableValue>();
    }

    public SerializableArray(SortedMap<String, String> properties, List<SerializableValue> elements) {
        super(properties);
        this.elements = elements;
    }

    public List<SerializableValue> getElements() {
        return this.elements;
    }

    @Override
    public Collection<SerializableValue> getInnerValues() {
        HashSet<SerializableValue> result = new HashSet<SerializableValue>(this.elements);
        for (SerializableValue inner : this.elements) {
            result.addAll(inner.getInnerValues());
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableArray other = (SerializableArray)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    public String toString() {
        return "[" + StringUtils.join(this.elements, (String)", ") + "]";
    }

    @Override
    public int compareTo(SerializableValue o) {
        if (o instanceof SerializableString) {
            return 1;
        }
        if (o instanceof SerializableObject) {
            return -1;
        }
        SerializableArray other = (SerializableArray)o;
        int cmp = Integer.compare(this.elements.size(), other.elements.size());
        if (cmp != 0) {
            return cmp;
        }
        CollectionsDiffBuilder<SerializableValue> builder = new CollectionsDiffBuilder<SerializableValue>(SerializableValue.class, this.elements, other.elements);
        builder.compute(SerializableValue::compareTo);
        if (builder.sameContent()) {
            return super.compareTo(o);
        }
        return builder.getOnlyFirst().iterator().next().compareTo(builder.getOnlySecond().iterator().next());
    }
}

