/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs.compare;

import it.unive.lisa.outputs.json.JsonReport;
import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableNodeDescription;
import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableString;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class JsonReportComparer {
    private static final Logger LOG = LogManager.getLogger(JsonReportComparer.class);
    private static final String MISSING_FILE = "'%s' declared as output in the %s report does not exist";
    private static final String VIS_ONLY = "Skipping comparison of visualization-only files: '{}' and '{}'";
    private static final String CANNOT_COMPARE = "Cannot compare files '%s' and '%s'";
    private static final String MALFORMED_GRAPH = "Graphs are different but have same structure and descriptions";
    private static final String GRAPH_DIFF = "Graphs have different structure";
    private static final String NO_DESC = "%s graph does not have a desciption for node %d: %s";
    private static final String DESC_DIFF = "Different desciption for node %d (%s)";
    private static final String DESC_DIFF_VERBOSE = "Different desciption for node %d (%s):\n%s";
    private static final Set<String> INFO_BLACKLIST = Set.of("duration", "start", "end", "version");

    public static boolean compare(JsonReport first, JsonReport second, File firstFileRoot, File secondFileRoot) throws IOException {
        return JsonReportComparer.compare(first, second, firstFileRoot, secondFileRoot, new BaseDiffAlgorithm());
    }

    public static boolean compare(JsonReport first, JsonReport second, File firstFileRoot, File secondFileRoot, DiffAlgorithm diff) throws IOException {
        boolean sameFileContents;
        boolean sameWarnings;
        boolean sameInfos;
        boolean sameConfs;
        boolean bl = sameConfs = !diff.shouldCompareConfigurations() || JsonReportComparer.compareConfs(first, second, diff);
        if (diff.shouldFailFast() && !sameConfs) {
            return false;
        }
        boolean bl2 = sameInfos = !diff.shouldCompareRunInfos() || JsonReportComparer.compareInfos(first, second, diff);
        if (diff.shouldFailFast() && !sameInfos) {
            return false;
        }
        boolean bl3 = sameWarnings = !diff.shouldCompareWarnings() || JsonReportComparer.compareWarnings(first, second, diff);
        if (diff.shouldFailFast() && !sameWarnings) {
            return false;
        }
        boolean sameFiles = !diff.shouldCompareFiles();
        CollectionsDiffBuilder<String> files = null;
        if (!sameFiles) {
            files = JsonReportComparer.compareFiles(first, second, diff);
            sameFiles = files.sameContent();
            if (diff.shouldFailFast() && !sameFiles) {
                return false;
            }
        }
        boolean bl4 = sameFileContents = !diff.shouldCompareFileContents();
        if (!sameFileContents) {
            if (files == null) {
                files = JsonReportComparer.compareFiles(first, second, diff);
                sameFiles = files.sameContent();
            }
            sameFileContents = JsonReportComparer.compareFileContents(firstFileRoot, secondFileRoot, diff, files);
            if (!(!diff.shouldFailFast() || sameFileContents && sameFiles)) {
                return false;
            }
        }
        return sameConfs && sameInfos && sameWarnings && sameFiles && sameFileContents;
    }

    private static boolean compareFileContents(File firstFileRoot, File secondFileRoot, DiffAlgorithm diff, CollectionsDiffBuilder<String> files) throws FileNotFoundException, IOException {
        boolean diffFound = false;
        for (Pair<String, String> pair : files.getCommons()) {
            File left = new File(firstFileRoot, (String)pair.getLeft());
            if (!left.exists()) {
                throw new FileNotFoundException(String.format(MISSING_FILE, pair.getLeft(), "first"));
            }
            File right = new File(secondFileRoot, (String)pair.getRight());
            if (!right.exists()) {
                throw new FileNotFoundException(String.format(MISSING_FILE, pair.getRight(), "second"));
            }
            String path = left.getName();
            if (FilenameUtils.getName((String)path).equals("report.json")) continue;
            if (diff.isJsonGraph(path)) {
                diffFound |= JsonReportComparer.matchJsonGraphs(diff, left, right);
                continue;
            }
            if (diff.isVisualizationFile(path)) {
                LOG.info(VIS_ONLY, (Object)left.toString(), (Object)right.toString());
                continue;
            }
            diffFound |= diff.customFileCompare(left, right);
        }
        return !diffFound;
    }

    private static CollectionsDiffBuilder<String> compareFiles(JsonReport first, JsonReport second, DiffAlgorithm diff) {
        CollectionsDiffBuilder<String> files = new CollectionsDiffBuilder<String>(String.class, first.getFiles(), second.getFiles());
        files.compute(String::compareTo);
        if (!files.getCommons().isEmpty()) {
            diff.report(REPORTED_COMPONENT.FILES, REPORT_TYPE.COMMON, files.getCommons());
        }
        if (!files.getOnlyFirst().isEmpty()) {
            diff.report(REPORTED_COMPONENT.FILES, REPORT_TYPE.ONLY_FIRST, files.getOnlyFirst());
        }
        if (!files.getOnlySecond().isEmpty()) {
            diff.report(REPORTED_COMPONENT.FILES, REPORT_TYPE.ONLY_SECOND, files.getOnlySecond());
        }
        return files;
    }

    private static boolean compareConfs(JsonReport first, JsonReport second, DiffAlgorithm diff) {
        return JsonReportComparer.compareBags(REPORTED_COMPONENT.CONFIGURATION, first.getConfiguration(), second.getConfiguration(), diff, (TriConsumer<String, String, String>)((TriConsumer)(key, fvalue, svalue) -> diff.configurationDiff((String)key, (String)fvalue, (String)svalue)), key -> false);
    }

    private static boolean compareInfos(JsonReport first, JsonReport second, DiffAlgorithm diff) {
        return JsonReportComparer.compareBags(REPORTED_COMPONENT.INFO, first.getInfo(), second.getInfo(), diff, (TriConsumer<String, String, String>)((TriConsumer)(key, fvalue, svalue) -> diff.infoDiff((String)key, (String)fvalue, (String)svalue)), key -> INFO_BLACKLIST.contains(key));
    }

    private static boolean compareBags(REPORTED_COMPONENT component, Map<String, String> first, Map<String, String> second, DiffAlgorithm diff, TriConsumer<String, String, String> reporter, Predicate<String> ignore) {
        CollectionsDiffBuilder<String> builder = new CollectionsDiffBuilder<String>(String.class, first.keySet(), second.keySet());
        builder.compute(String::compareTo);
        if (!builder.getOnlyFirst().isEmpty()) {
            diff.report(component, REPORT_TYPE.ONLY_FIRST, builder.getOnlyFirst());
        }
        if (!builder.getOnlySecond().isEmpty()) {
            diff.report(component, REPORT_TYPE.ONLY_SECOND, builder.getOnlySecond());
        }
        HashSet<Pair> same = new HashSet<Pair>();
        if (!builder.getCommons().isEmpty()) {
            for (Pair<String, String> entry : builder.getCommons()) {
                String svalue;
                String key = (String)entry.getKey();
                String fvalue = first.get(key);
                if (fvalue.equals(svalue = second.get(key)) || ignore.test(key)) {
                    same.add(Pair.of((Object)key, (Object)fvalue));
                    continue;
                }
                reporter.accept((Object)key, (Object)fvalue, (Object)svalue);
            }
        }
        if (!same.isEmpty()) {
            diff.report(component, REPORT_TYPE.COMMON, same);
        }
        return builder.sameContent() && same.size() == builder.getCommons().size();
    }

    private static boolean compareWarnings(JsonReport first, JsonReport second, DiffAlgorithm diff) {
        CollectionsDiffBuilder<JsonReport.JsonWarning> warnings = new CollectionsDiffBuilder<JsonReport.JsonWarning>(JsonReport.JsonWarning.class, first.getWarnings(), second.getWarnings());
        warnings.compute(JsonReport.JsonWarning::compareTo);
        if (!warnings.getCommons().isEmpty()) {
            diff.report(REPORTED_COMPONENT.WARNINGS, REPORT_TYPE.COMMON, warnings.getCommons());
        }
        if (!warnings.getOnlyFirst().isEmpty()) {
            diff.report(REPORTED_COMPONENT.WARNINGS, REPORT_TYPE.ONLY_FIRST, warnings.getOnlyFirst());
        }
        if (!warnings.getOnlySecond().isEmpty()) {
            diff.report(REPORTED_COMPONENT.WARNINGS, REPORT_TYPE.ONLY_SECOND, warnings.getOnlySecond());
        }
        return warnings.sameContent();
    }

    private static boolean matchJsonGraphs(DiffAlgorithm diff, File left, File right) throws IOException, FileNotFoundException {
        boolean diffFound = false;
        try (InputStreamReader l = new InputStreamReader((InputStream)new FileInputStream(left), StandardCharsets.UTF_8);
             InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(right), StandardCharsets.UTF_8);){
            SerializableGraph leftGraph = SerializableGraph.readGraph(l);
            SerializableGraph rightGraph = SerializableGraph.readGraph(r);
            if (!leftGraph.equals(rightGraph)) {
                diffFound = true;
                String leftpath = left.toString();
                String rightpath = right.toString();
                if (!leftGraph.sameStructure(rightGraph)) {
                    diff.fileDiff(leftpath, rightpath, GRAPH_DIFF);
                } else {
                    CollectionsDiffBuilder<SerializableNodeDescription> builder = new CollectionsDiffBuilder<SerializableNodeDescription>(SerializableNodeDescription.class, leftGraph.getDescriptions(), rightGraph.getDescriptions());
                    builder.compute(SerializableNodeDescription::compareTo);
                    if (builder.sameContent()) {
                        diff.fileDiff(leftpath, rightpath, MALFORMED_GRAPH);
                    } else {
                        JsonReportComparer.compareLabels(diff, leftGraph, rightGraph, leftpath, rightpath, builder);
                    }
                }
            }
        }
        return diffFound;
    }

    private static void compareLabels(DiffAlgorithm diff, SerializableGraph leftGraph, SerializableGraph rightGraph, String leftpath, String rightpath, CollectionsDiffBuilder<SerializableNodeDescription> builder) {
        HashMap llabels = new HashMap();
        HashMap rlabels = new HashMap();
        leftGraph.getNodes().forEach(d -> llabels.put(d.getId(), d.getText()));
        rightGraph.getNodes().forEach(d -> rlabels.put(d.getId(), d.getText()));
        Iterator<SerializableNodeDescription> ol = builder.getOnlyFirst().iterator();
        Iterator<SerializableNodeDescription> or = builder.getOnlySecond().iterator();
        SerializableNodeDescription currentF = null;
        SerializableNodeDescription currentS = null;
        while (ol.hasNext() && or.hasNext()) {
            int sid;
            if (ol.hasNext() && currentF == null) {
                currentF = ol.next();
            }
            if (or.hasNext() && currentS == null) {
                currentS = or.next();
            }
            if (currentF == null) {
                if (currentS == null) break;
                diff.fileDiff(leftpath, rightpath, String.format(NO_DESC, "First", currentS.getNodeId(), rlabels.get(currentS.getNodeId())));
                currentS = null;
                continue;
            }
            if (currentS == null) {
                diff.fileDiff(leftpath, rightpath, String.format(NO_DESC, "Second", currentF.getNodeId(), llabels.get(currentF.getNodeId())));
                currentF = null;
                continue;
            }
            int fid = currentF.getNodeId();
            if (fid == (sid = currentS.getNodeId())) {
                if (diff.verboseLabelDiff()) {
                    diff.fileDiff(leftpath, rightpath, String.format(DESC_DIFF_VERBOSE, currentF.getNodeId(), llabels.get(currentF.getNodeId()), JsonReportComparer.diff(currentF.getDescription(), currentS.getDescription())));
                } else {
                    diff.fileDiff(leftpath, rightpath, String.format(DESC_DIFF, currentF.getNodeId(), llabels.get(currentF.getNodeId())));
                }
                currentF = null;
                currentS = null;
                continue;
            }
            if (fid < sid) {
                diff.fileDiff(leftpath, rightpath, String.format(NO_DESC, "Second", currentF.getNodeId(), llabels.get(currentF.getNodeId())));
                currentF = null;
                continue;
            }
            diff.fileDiff(leftpath, rightpath, String.format(NO_DESC, "First", currentS.getNodeId(), rlabels.get(currentS.getNodeId())));
            currentS = null;
        }
    }

    private static final String diff(SerializableValue first, SerializableValue second) {
        StringBuilder builder = new StringBuilder();
        JsonReportComparer.diff(0, builder, first, second);
        return builder.toString().replaceAll("(?m)^[ \t]*\r?\n", "").trim();
    }

    private static final boolean diff(int depth, StringBuilder builder, SerializableValue first, SerializableValue second) {
        if (first.getClass() != second.getClass()) {
            JsonReportComparer.fillWithDiff(depth, builder, first, second);
            return true;
        }
        if (first instanceof SerializableString) {
            return JsonReportComparer.diff(depth, builder, (SerializableString)first, (SerializableString)second);
        }
        if (first instanceof SerializableArray) {
            return JsonReportComparer.diff(depth, builder, (SerializableArray)first, (SerializableArray)second);
        }
        return JsonReportComparer.diff(depth, builder, (SerializableObject)first, (SerializableObject)second);
    }

    private static final boolean diff(int depth, StringBuilder builder, SerializableString first, SerializableString second) {
        if (!first.getValue().equals(second.getValue())) {
            JsonReportComparer.fillWithDiff(depth, builder, first, second);
            return true;
        }
        return false;
    }

    private static final boolean diff(int depth, StringBuilder builder, SerializableArray first, SerializableArray second) {
        int i;
        List<SerializableValue> felements = first.getElements();
        List<SerializableValue> selements = second.getElements();
        int fsize = felements.size();
        int ssize = selements.size();
        int min = Math.min(fsize, ssize);
        boolean atLeastOne = false;
        for (i = 0; i < min; ++i) {
            StringBuilder inner = new StringBuilder();
            if (!JsonReportComparer.diff(depth + 1, inner, felements.get(i), selements.get(i))) continue;
            builder.append("\t".repeat(depth)).append(">ELEMENT #").append(i).append(":\n").append(inner.toString()).append("\n");
            atLeastOne = true;
        }
        if (fsize > min) {
            builder.append("\t".repeat(depth)).append(">EXPECTED HAS ").append(fsize - min).append(" MORE ELEMENT(S):\n");
            for (i = min; i < fsize; ++i) {
                builder.append("\t".repeat(depth + 1)).append(">ELEMENT #").append(i).append(":\n").append("\t".repeat(depth + 2)).append(felements.get(i)).append("\n");
            }
            atLeastOne = true;
        }
        if (ssize > min) {
            builder.append("\t".repeat(depth)).append(">ACTUAL HAS ").append(ssize - min).append(" MORE ELEMENT(S):\n");
            for (i = min; i < ssize; ++i) {
                builder.append("\t".repeat(depth + 1)).append(">ELEMENT #").append(i).append(":\n").append("\t".repeat(depth + 2)).append(selements.get(i)).append("\n");
            }
            atLeastOne = true;
        }
        return atLeastOne;
    }

    private static final boolean diff(int depth, StringBuilder builder, SerializableObject first, SerializableObject second) {
        SortedMap<String, SerializableValue> felements = first.getFields();
        SortedMap<String, SerializableValue> selements = second.getFields();
        CollectionsDiffBuilder<String> diff = new CollectionsDiffBuilder<String>(String.class, felements.keySet(), selements.keySet());
        diff.compute(String::compareTo);
        boolean atLeastOne = false;
        Iterator<Object> iterator = diff.getCommons().iterator();
        while (iterator.hasNext()) {
            StringBuilder inner = new StringBuilder();
            Pair<String, String> pair = iterator.next();
            if (!JsonReportComparer.diff(depth + 1, inner, (SerializableValue)felements.get(pair.getLeft()), (SerializableValue)selements.get(pair.getLeft()))) continue;
            builder.append("\t".repeat(depth)).append(">FIELD ").append((String)pair.getLeft()).append(":\n").append(inner.toString()).append("\n");
            atLeastOne = true;
        }
        if (!diff.getOnlyFirst().isEmpty()) {
            builder.append("\t".repeat(depth)).append(">EXPECTED HAS ").append(diff.getOnlyFirst().size()).append(" MORE FIELD(S):\n");
            for (String string : diff.getOnlyFirst()) {
                builder.append("\t".repeat(depth + 1)).append(">FIELD ").append(string).append(":\n").append("\t".repeat(depth + 2)).append(felements.get(string)).append("\n");
            }
            atLeastOne = true;
        }
        if (!diff.getOnlySecond().isEmpty()) {
            builder.append("\t".repeat(depth)).append(">ACTUAL HAS ").append(diff.getOnlySecond().size()).append(" MORE FIELD(S):\n");
            for (String string : diff.getOnlySecond()) {
                builder.append("\t".repeat(depth + 1)).append(">FIELD ").append(string).append(":\n").append("\t".repeat(depth + 2)).append(selements.get(string)).append("\n");
            }
            atLeastOne = true;
        }
        return atLeastOne;
    }

    private static final void fillWithDiff(int depth, StringBuilder builder, SerializableValue first, SerializableValue second) {
        builder.append("\t".repeat(depth)).append(first).append("\n").append("\t".repeat(depth)).append("<--->\n").append("\t".repeat(depth)).append(second);
    }

    public static class BaseDiffAlgorithm
    implements DiffAlgorithm {
        private static final Logger LOG = LogManager.getLogger(BaseDiffAlgorithm.class);
        private static final String FILES_ONLY = "Files only in the {} report:";
        private static final String WARNINGS_ONLY = "Warnings only in the {} report:";
        private static final String INFOS_ONLY = "Run info keys only in the {} report:";
        private static final String CONFS_ONLY = "Configuration keys only in the {} report:";
        private static final String FILE_DIFF = "['{}'] {}";
        private static final String VALUE_DIFF = "Different values for {} key '{}': '{}' and '{}'";

        @Override
        public void report(REPORTED_COMPONENT component, REPORT_TYPE type, Collection<?> reported) {
            if (type == REPORT_TYPE.COMMON) {
                return;
            }
            boolean isFirst = type == REPORT_TYPE.ONLY_FIRST;
            switch (component) {
                case FILES: {
                    if (isFirst) {
                        LOG.warn(FILES_ONLY, (Object)"first");
                        break;
                    }
                    LOG.warn(FILES_ONLY, (Object)"second");
                    break;
                }
                case WARNINGS: {
                    if (isFirst) {
                        LOG.warn(WARNINGS_ONLY, (Object)"first");
                        break;
                    }
                    LOG.warn(WARNINGS_ONLY, (Object)"second");
                    break;
                }
                case INFO: {
                    if (isFirst) {
                        LOG.warn(INFOS_ONLY, (Object)"first");
                        break;
                    }
                    LOG.warn(INFOS_ONLY, (Object)"second");
                    break;
                }
                case CONFIGURATION: {
                    if (isFirst) {
                        LOG.warn(CONFS_ONLY, (Object)"first");
                        break;
                    }
                    LOG.warn(CONFS_ONLY, (Object)"second");
                    break;
                }
            }
            for (Object o : reported) {
                LOG.warn("\t" + o);
            }
        }

        @Override
        public void fileDiff(String first, String second, String message) {
            String fname = FilenameUtils.getName((String)first);
            LOG.warn(FILE_DIFF, (Object)fname, (Object)message);
        }

        @Override
        public void infoDiff(String key, String first, String second) {
            LOG.warn(VALUE_DIFF, (Object)"run info", (Object)key, (Object)first, (Object)second);
        }

        @Override
        public void configurationDiff(String key, String first, String second) {
            LOG.warn(VALUE_DIFF, (Object)"configuration", (Object)key, (Object)first, (Object)second);
        }
    }

    public static interface DiffAlgorithm {
        public void report(REPORTED_COMPONENT var1, REPORT_TYPE var2, Collection<?> var3);

        public void fileDiff(String var1, String var2, String var3);

        public void infoDiff(String var1, String var2, String var3);

        public void configurationDiff(String var1, String var2, String var3);

        default public boolean shouldCompareConfigurations() {
            return true;
        }

        default public boolean shouldCompareRunInfos() {
            return true;
        }

        default public boolean shouldCompareWarnings() {
            return true;
        }

        default public boolean shouldCompareFiles() {
            return true;
        }

        default public boolean shouldCompareFileContents() {
            return true;
        }

        default public boolean shouldFailFast() {
            return false;
        }

        default public boolean isJsonGraph(String path) {
            return FilenameUtils.getExtension((String)path).equals("json");
        }

        default public boolean isVisualizationFile(String path) {
            String ext = FilenameUtils.getExtension((String)path);
            return ext.equals("dot") || ext.equals("graphml") || ext.equals("html") || ext.equals("js");
        }

        default public boolean customFileCompare(File expected, File actual) {
            throw new UnsupportedOperationException(String.format(JsonReportComparer.CANNOT_COMPARE, expected.toString(), actual.toString()));
        }

        default public boolean verboseLabelDiff() {
            return true;
        }
    }

    public static enum REPORTED_COMPONENT {
        INFO,
        CONFIGURATION,
        WARNINGS,
        FILES;

    }

    public static enum REPORT_TYPE {
        COMMON,
        ONLY_FIRST,
        ONLY_SECOND;

    }
}

