/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs;

import it.unive.lisa.outputs.GraphStreamWrapper;
import it.unive.lisa.outputs.GraphmlGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableNodeDescription;
import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableString;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HtmlGraph
extends GraphStreamWrapper {
    private final GraphmlGraph graph;
    private final String description;
    private final SortedMap<Integer, Pair<String, SerializableNodeDescription>> descriptions;
    private final String descriptionLabel;
    private final boolean includeSubnodes;

    public HtmlGraph(GraphmlGraph graph, boolean includeSubnodes, SortedMap<Integer, Pair<String, SerializableNodeDescription>> map, String description, String descriptionLabel) {
        this.graph = graph;
        this.descriptions = map;
        this.description = description;
        this.descriptionLabel = descriptionLabel;
        this.includeSubnodes = includeSubnodes;
    }

    @Override
    public void dump(Writer writer) throws IOException {
        StringWriter graphWriter = new StringWriter();
        this.graph.dump(graphWriter, false);
        String graphText = graphWriter.toString().replace("&apos;", "'").replace("'", "\\'").replace("\n", "\\n");
        String graphTitle = this.graph.getTitle();
        String graphDescription = "";
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            graphDescription = this.description;
        }
        String file = this.includeSubnodes ? "html-graph/viewer-compound.html" : "html-graph/viewer.html";
        try (InputStream viewer = this.getClass().getClassLoader().getResourceAsStream(file);){
            String viewerCode = IOUtils.toString((InputStream)viewer, (Charset)StandardCharsets.UTF_8);
            viewerCode = viewerCode.replace("$$$GRAPH_TITLE$$$", graphTitle);
            viewerCode = viewerCode.replace("$$$GRAPH_DESCRIPTION$$$", graphDescription);
            viewerCode = viewerCode.replace("$$$GRAPH_DESCRIPTION_LABEL$$$", this.descriptionLabel);
            viewerCode = viewerCode.replace("$$$GRAPH_CONTENT$$$", graphText);
            StringBuilder descrs = new StringBuilder();
            for (Map.Entry<Integer, Pair<String, SerializableNodeDescription>> d : this.descriptions.entrySet()) {
                String nodeName = HtmlGraph.nodeName(d.getKey().intValue());
                if (!this.includeSubnodes && this.graph.graph.getNode(nodeName) == null) continue;
                descrs.append("\t\t\t\t<div id=\"header-").append(nodeName).append("\" class=\"header-hidden\">\n");
                descrs.append("\t\t\t\t\t<div class=\"description-title-wrapper\"><span class=\"description-title\">").append(StringUtils.capitalize((String)this.descriptionLabel)).append(" for ").append("</span><span class=\"description-title-text\">").append((String)d.getValue().getLeft()).append("</span></div>\n");
                HtmlGraph.populate(descrs, 5, ((SerializableNodeDescription)d.getValue().getRight()).getDescription());
                descrs.append("\t\t\t\t</div>\n");
            }
            viewerCode = viewerCode.replace("$$$GRAPH_DESCRIPTIONS$$$", descrs.toString().trim());
            writer.write(viewerCode);
        }
    }

    private static void populate(StringBuilder descrs, int depth, SerializableValue value) {
        if (value instanceof SerializableString) {
            descrs.append(value.toString());
        } else if (value instanceof SerializableArray) {
            SerializableArray array = (SerializableArray)value;
            if (array.getElements().stream().allMatch(SerializableString.class::isInstance)) {
                descrs.append("[");
                for (int i = 0; i < array.getElements().size(); ++i) {
                    if (i != 0) {
                        descrs.append(", ");
                    }
                    HtmlGraph.populate(descrs, depth + 1, array.getElements().get(i));
                }
                descrs.append("]");
            } else {
                for (int i = 0; i < array.getElements().size(); ++i) {
                    descrs.append("\t".repeat(depth)).append("<span class=\"description-header\">Element ").append(i).append(":</span><br/>\n");
                    descrs.append("\t".repeat(depth)).append("<div class=\"description-nest\">\n");
                    HtmlGraph.populate(descrs, depth + 1, array.getElements().get(i));
                    descrs.append("\t".repeat(depth)).append("</div>\n");
                }
            }
        } else if (value instanceof SerializableObject) {
            SerializableObject object = (SerializableObject)value;
            for (Map.Entry<String, SerializableValue> field : object.getFields().entrySet()) {
                descrs.append("\t".repeat(depth)).append("<span class=\"description-header\">").append(field.getKey()).append(": </span>");
                if (HtmlGraph.isStringLike(field.getValue())) {
                    HtmlGraph.populate(descrs, depth + 1, field.getValue());
                    descrs.append("<br/>\n");
                    continue;
                }
                descrs.append("<br/>\n");
                descrs.append("\t".repeat(depth)).append("<div class=\"description-nest\">\n");
                HtmlGraph.populate(descrs, depth + 1, field.getValue());
                descrs.append("\t".repeat(depth)).append("</div>\n");
            }
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isStringLike(SerializableValue value) {
        if (value instanceof SerializableString) return true;
        if (!(value instanceof SerializableArray)) return false;
        if (!((SerializableArray)value).getElements().stream().allMatch(SerializableString.class::isInstance)) return false;
        return true;
    }
}

