/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs;

import it.unive.lisa.outputs.GraphStreamWrapper;
import it.unive.lisa.outputs.OutputDumpingException;
import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableEdge;
import it.unive.lisa.outputs.serializableGraph.SerializableNode;
import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableString;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSinkGraphML;

public class GraphmlGraph
extends GraphStreamWrapper {
    private static final String QUALIFIER = "::";
    private static final String LABEL_QUALIFIER = "::LABEL";
    private static final String ARRAY_QUALIFIER = "::ARRAY";
    private static final String ELEMENT_QUALIFIER = "::ELEMENT";
    private static final String NODE_SUBNODE_PREFIX = "NODE_SUBNODE_";
    private static final String LABEL_FIELD_PREFIX = "LABEL_FIELD_";
    private static final String LABEL_ARRAY = "LABEL_ARRAY";
    private static final String LABEL_TEXT = "LABEL_TEXT";
    private static final String KIND_DESCRIPTION = "DESCRIPTION";
    private static final String KIND_SUBNODE = "SUBNODE";
    private static final String EDGE_KIND = "EDGE_KIND";
    private static final String NODE_KIND = "NODE_KIND";
    private static final String NODE_LABEL = "NODE_LABEL";
    private static final String NODE_TEXT = "NODE_TEXT";
    private static final String NODE_CONTENT = "NODE_CONTENT";
    private static final String NODE_IS_EXIT = "NODE_IS_EXIT";
    private static final String NODE_IS_ENTRY = "NODE_IS_ENTRY";
    private static final String GRAPH_TITLE = "GRAPH_TITLE";
    private static final String NO = "no";
    private static final String YES = "yes";
    private final Map<String, AtomicInteger> subnodesCount = new HashMap<String, AtomicInteger>();
    private final String title;

    public GraphmlGraph(String title) {
        this.graph.setAttribute(GRAPH_TITLE, new Object[]{title});
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void addNode(SerializableNode node, boolean entry, boolean exit, SerializableValue label) {
        Node n = this.graph.addNode(GraphmlGraph.nodeName(node.getId()));
        if (entry) {
            n.setAttribute(NODE_IS_ENTRY, new Object[]{YES});
        } else {
            n.setAttribute(NODE_IS_ENTRY, new Object[]{NO});
        }
        if (exit) {
            n.setAttribute(NODE_IS_EXIT, new Object[]{YES});
        } else {
            n.setAttribute(NODE_IS_EXIT, new Object[]{NO});
        }
        n.setAttribute(NODE_TEXT, new Object[]{node.getText()});
        if (label != null) {
            String graphname = node.getId() + LABEL_QUALIFIER;
            MultiGraph labelgraph = new MultiGraph(graphname);
            this.populate(graphname, 0, labelgraph, label);
            MultiGraph wrappergraph = new MultiGraph(graphname + "_WRAPPER");
            Node wrapper = wrappergraph.addNode(graphname + "_WRAPPERNODE");
            wrapper.setAttribute(NODE_KIND, new Object[]{KIND_DESCRIPTION});
            wrapper.setAttribute(NODE_CONTENT, new Object[]{labelgraph});
            n.setAttribute(NODE_LABEL, new Object[]{wrappergraph});
        }
    }

    private void populate(String prefix, int depth, MultiGraph g, SerializableValue value) {
        if (value instanceof SerializableString) {
            Node node = g.addNode(prefix + ELEMENT_QUALIFIER);
            node.setAttribute(LABEL_TEXT, new Object[]{value.toString()});
            value.getProperties().forEach((k, v) -> node.setAttribute(k, new Object[]{v}));
        } else if (value instanceof SerializableArray) {
            SerializableArray array = (SerializableArray)value;
            if (array.getElements().stream().allMatch(SerializableString.class::isInstance)) {
                Node node = g.addNode(prefix + ELEMENT_QUALIFIER);
                node.setAttribute(LABEL_TEXT, new Object[]{value.toString()});
                value.getProperties().forEach((k, v) -> node.setAttribute(k, new Object[]{v}));
            } else {
                for (int i = 0; i < array.getElements().size(); ++i) {
                    String graphname = prefix + QUALIFIER + depth + "::ARRAY::" + i;
                    Node node = g.addNode(graphname);
                    SerializableValue array_element = array.getElements().get(i);
                    MultiGraph labelgraph = new MultiGraph(graphname);
                    this.populate(graphname, depth + 1, labelgraph, array_element);
                    node.setAttribute(LABEL_ARRAY, new Object[]{labelgraph});
                    node.setAttribute(LABEL_TEXT, new Object[]{"Element " + i});
                    array_element.getProperties().forEach((k, v) -> node.setAttribute(k, new Object[]{v}));
                }
            }
        } else if (value instanceof SerializableObject) {
            SerializableObject object = (SerializableObject)value;
            for (Map.Entry<String, SerializableValue> field : object.getFields().entrySet()) {
                String graphname = prefix + QUALIFIER + depth + QUALIFIER + field.getKey();
                Node node = g.addNode(graphname);
                MultiGraph labelgraph = new MultiGraph(graphname);
                this.populate(graphname, depth + 1, labelgraph, field.getValue());
                node.setAttribute(LABEL_FIELD_PREFIX + field.getKey(), new Object[]{labelgraph});
                node.setAttribute(LABEL_TEXT, new Object[]{field.getKey()});
                field.getValue().getProperties().forEach((k, v) -> node.setAttribute(k, new Object[]{v}));
            }
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass().getName());
        }
    }

    public void markSubNode(SerializableNode node, SerializableNode inner) {
        Node sub = this.graph.removeNode(GraphmlGraph.nodeName(inner.getId()));
        Node outer = this.graph.getNode(GraphmlGraph.nodeName(node.getId()));
        String graphname = node.getId() + QUALIFIER + inner.getId();
        MultiGraph innergraph = new MultiGraph(graphname);
        Node n = innergraph.addNode(sub.getId());
        sub.attributeKeys().forEach(k -> n.setAttribute(k, new Object[]{sub.getAttribute(k)}));
        n.setAttribute(NODE_KIND, new Object[]{KIND_SUBNODE});
        AtomicInteger counter = this.subnodesCount.computeIfAbsent(GraphmlGraph.nodeName(node.getId()), k -> new AtomicInteger(0));
        int idx = counter.getAndIncrement();
        outer.setAttribute(NODE_SUBNODE_PREFIX + idx, new Object[]{innergraph});
    }

    public void addEdge(SerializableEdge edge) {
        long id = edge.getSourceId();
        long id1 = edge.getDestId();
        Edge e = this.graph.addEdge(GraphmlGraph.edgeName(id, id1), GraphmlGraph.nodeName(id), GraphmlGraph.nodeName(id1), true);
        e.setAttribute(EDGE_KIND, new Object[]{edge.getKind()});
    }

    @Override
    public void dump(Writer writer) throws IOException {
        this.dump(writer, true);
    }

    public void dump(Writer writer, boolean format) throws IOException {
        CustomGraphMLSink sink = new CustomGraphMLSink(format);
        sink.writeAll(this.graph, writer);
    }

    private static class CustomGraphMLSink
    extends FileSinkGraphML {
        private final boolean format;

        private CustomGraphMLSink(boolean format) {
            this.format = format;
        }

        private void print(int indent, String format, Object ... args) throws IOException {
            Object out = "";
            if (this.format) {
                out = (String)out + "\t".repeat(indent);
            }
            out = args.length == 0 ? (String)out + format : (String)out + String.format(format, args);
            if (this.format) {
                out = (String)out + "\n";
            }
            this.output.write((String)out);
        }

        protected void outputEndOfFile() throws IOException {
            this.print(0, "</graphml>", new Object[0]);
        }

        protected void outputHeader() throws IOException {
            this.print(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", new Object[0]);
            this.print(0, "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"", new Object[0]);
            this.print(1, " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", new Object[0]);
            this.print(1, " xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns", new Object[0]);
            this.print(1, "   http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">", new Object[0]);
        }

        private static String escapeXmlString(String string) {
            return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
        }

        protected void exportGraph(Graph g) {
            TreeMap<String, String> nodeAttributes = new TreeMap<String, String>();
            TreeMap<String, String> edgeAttributes = new TreeMap<String, String>();
            this.collectKeys(g, nodeAttributes, edgeAttributes);
            this.dumpKeys(nodeAttributes, edgeAttributes);
            this.dumpGraph(g, nodeAttributes, edgeAttributes);
        }

        protected void processAttribute(String key, Object value, Map<String, String> attributes, Map<String, String> nodeAttributes, Map<String, String> edgeAttributes) {
            if (value == null) {
                throw new OutputDumpingException("Attribute with no value are not supported");
            }
            if (value instanceof Graph) {
                this.collectKeys((Graph)value, nodeAttributes, edgeAttributes);
                return;
            }
            String type = value instanceof Boolean ? "boolean" : (value instanceof Long ? "long" : (value instanceof Integer ? "int" : (value instanceof Double ? "double" : (value instanceof Float ? "float" : "string"))));
            if (!attributes.containsKey(key)) {
                attributes.put(key, type);
            } else if (!attributes.get(key).equals(type)) {
                throw new OutputDumpingException("Attributes with the same name have different value type");
            }
        }

        protected void collectKeys(Graph g, Map<String, String> nodeAttributes, Map<String, String> edgeAttributes) {
            g.nodes().forEach(n -> n.attributeKeys().forEach(k -> this.processAttribute((String)k, n.getAttribute(k), nodeAttributes, nodeAttributes, edgeAttributes)));
            g.edges().forEach(e -> e.attributeKeys().forEach(k -> this.processAttribute((String)k, e.getAttribute(k), edgeAttributes, nodeAttributes, edgeAttributes)));
        }

        protected void dumpKeys(Map<String, String> nodeAttributes, Map<String, String> edgeAttributes) {
            for (Map.Entry<String, String> entry : nodeAttributes.entrySet()) {
                try {
                    this.print(1, "<key id=\"%s\" for=\"node\" attr.name=\"%s\" attr.type=\"%s\"/>", entry.getKey(), entry.getKey(), entry.getValue());
                }
                catch (Exception ex) {
                    throw new OutputDumpingException("Exception while dumping graphml attribute key", ex);
                }
            }
            for (Map.Entry<String, String> entry : edgeAttributes.entrySet()) {
                try {
                    this.print(1, "<key id=\"%s\" for=\"edge\" attr.name=\"%s\" attr.type=\"%s\"/>", entry.getKey(), entry.getKey(), entry.getValue());
                }
                catch (Exception ex) {
                    throw new OutputDumpingException("Exception while dumping graphml attribute key", ex);
                }
            }
        }

        protected void dumpGraph(Graph g, Map<String, String> nodeAttributes, Map<String, String> edgeAttributes) {
            try {
                this.print(1, "<graph id=\"%s\" edgedefault=\"directed\">", CustomGraphMLSink.escapeXmlString(g.getId()));
            }
            catch (Exception e2) {
                throw new OutputDumpingException("Exception while dumping graphml graph element", e2);
            }
            g.nodes().forEach(n -> {
                try {
                    this.print(2, "<node id=\"%s\">", n.getId());
                    n.attributeKeys().forEach(k -> {
                        try {
                            Object value = n.getAttribute(k);
                            if (!(value instanceof Graph)) {
                                this.print(3, "<data key=\"%s\">%s</data>", k, CustomGraphMLSink.escapeXmlString(value.toString()));
                            } else {
                                Graph inner = (Graph)value;
                                CustomGraphMLSink innersink = new CustomGraphMLSink(this.format);
                                StringWriter innerwriter = new StringWriter();
                                innersink.output = innerwriter;
                                innersink.dumpGraph(inner, nodeAttributes, edgeAttributes);
                                if (this.format) {
                                    for (String line : innerwriter.toString().split("\n")) {
                                        this.print(2, line, new Object[0]);
                                    }
                                } else {
                                    this.print(0, innerwriter.toString(), new Object[0]);
                                }
                            }
                        }
                        catch (IOException ex) {
                            throw new OutputDumpingException("Exception while dumping graphml node attribute element", ex);
                        }
                    });
                    this.print(2, "</node>", new Object[0]);
                }
                catch (Exception ex) {
                    throw new OutputDumpingException("Exception while dumping graphml node element", ex);
                }
            });
            g.edges().forEach(e -> {
                try {
                    this.print(2, "<edge id=\"%s\" source=\"%s\" target=\"%s\" directed=\"%s\">", e.getId(), e.getSourceNode().getId(), e.getTargetNode().getId(), e.isDirected());
                    e.attributeKeys().forEach(k -> {
                        try {
                            this.print(3, "<data key=\"%s\">%s</data>", k, CustomGraphMLSink.escapeXmlString(e.getAttribute(k).toString()));
                        }
                        catch (IOException ex) {
                            throw new OutputDumpingException("Exception while dumping graphml edge attribute element", ex);
                        }
                    });
                    this.print(2, "</edge>", new Object[0]);
                }
                catch (Exception ex) {
                    throw new OutputDumpingException("Exception while dumping graphml edge element", ex);
                }
            });
            try {
                this.print(1, "</graph>", new Object[0]);
            }
            catch (Exception e3) {
                throw new OutputDumpingException("Exception while dumping graphml graph element", e3);
            }
        }
    }
}

