/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs;

import it.unive.lisa.outputs.GraphStreamWrapper;
import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableEdge;
import it.unive.lisa.outputs.serializableGraph.SerializableNode;
import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableString;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSinkDOT;
import org.graphstream.stream.file.FileSourceDOT;

public class DotGraph
extends GraphStreamWrapper {
    protected static final String COLOR_BLACK = "black";
    protected static final String COLOR_GRAY = "gray";
    protected static final String COLOR_RED = "red";
    protected static final String COLOR_BLUE = "blue";
    protected static final String STYLE = "style";
    protected static final String COLOR = "color";
    protected static final String SHAPE = "shape";
    protected static final String LABEL = "label";
    protected static final String EXIT_NODE_EXTRA_ATTR = "peripheries";
    protected static final String NODE_SHAPE = "rect";
    protected static final String EXIT_NODE_EXTRA_VALUE = "2";
    protected static final String SPECIAL_NODE_COLOR = "black";
    protected static final String NORMAL_NODE_COLOR = "gray";
    protected static final String CONDITIONAL_EDGE_STYLE = "dashed";
    private final Graph legend;
    private final String title;

    public DotGraph(String title) {
        this.legend = new Legend().graph;
        this.title = title;
    }

    private static String dotEscape(String extraLabel) {
        String escapeHtml4 = StringEscapeUtils.escapeHtml4((String)extraLabel);
        String replace = escapeHtml4.replace("\n", "<BR/>");
        replace = replace.replace("\\", "\\\\");
        return replace;
    }

    public void addNode(SerializableNode node, boolean entry, boolean exit, SerializableValue label) {
        Node n = this.graph.addNode(DotGraph.nodeName(node.getId()));
        n.setAttribute(SHAPE, new Object[]{NODE_SHAPE});
        if (entry || exit) {
            n.setAttribute(COLOR, new Object[]{"black"});
        } else {
            n.setAttribute(COLOR, new Object[]{"gray"});
        }
        if (exit) {
            n.setAttribute(EXIT_NODE_EXTRA_ATTR, new Object[]{EXIT_NODE_EXTRA_VALUE});
        }
        String l = DotGraph.dotEscape(node.getText());
        Object extra = "";
        if (label != null) {
            extra = "<BR/><BR/>" + DotGraph.dotEscape(DotGraph.format(label));
        }
        n.setAttribute(LABEL, new Object[]{"<" + l + (String)extra + ">"});
    }

    private static String format(SerializableValue value) {
        if (value instanceof SerializableString) {
            return value.toString();
        }
        if (value instanceof SerializableArray) {
            SerializableArray array = (SerializableArray)value;
            if (array.getElements().stream().allMatch(SerializableString.class::isInstance)) {
                return "[" + StringUtils.join(array.getElements(), (String)", ") + "]";
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (int i = 0; i < array.getElements().size(); ++i) {
                SerializableValue array_element = array.getElements().get(i);
                if (!first) {
                    builder.append(",\n");
                }
                first = false;
                builder.append(DotGraph.format(array_element));
            }
            return builder.toString();
        }
        if (value instanceof SerializableObject) {
            SerializableObject object = (SerializableObject)value;
            StringBuilder builder = new StringBuilder("{ ");
            boolean first = true;
            for (Map.Entry<String, SerializableValue> field : object.getFields().entrySet()) {
                SerializableValue fieldValue = field.getValue();
                if (!first) {
                    if (builder.toString().endsWith("\n")) {
                        builder.delete(builder.length() - 1, builder.length());
                    }
                    builder.append(",\n");
                }
                first = false;
                builder.append(field.getKey()).append(": ").append(DotGraph.format(fieldValue));
            }
            return builder.append(" }\n").toString();
        }
        throw new IllegalArgumentException("Unknown value type: " + value.getClass().getName());
    }

    public void addEdge(SerializableEdge edge) {
        long id = edge.getSourceId();
        long id1 = edge.getDestId();
        Edge e = this.graph.addEdge(DotGraph.edgeName(id, id1), DotGraph.nodeName(id), DotGraph.nodeName(id1), true);
        switch (edge.getKind()) {
            case "TrueEdge": {
                e.setAttribute(STYLE, new Object[]{CONDITIONAL_EDGE_STYLE});
                e.setAttribute(COLOR, new Object[]{COLOR_BLUE});
                break;
            }
            case "FalseEdge": {
                e.setAttribute(STYLE, new Object[]{CONDITIONAL_EDGE_STYLE});
                e.setAttribute(COLOR, new Object[]{COLOR_RED});
                break;
            }
            default: {
                e.setAttribute(COLOR, new Object[]{"black"});
            }
        }
    }

    @Override
    public void dump(Writer writer) throws IOException {
        CustomDotSink sink = new CustomDotSink(){

            protected void outputEndOfFile() throws IOException {
                if (DotGraph.this.legend != null) {
                    LegendClusterSink legend = new LegendClusterSink();
                    legend.setDirected(true);
                    StringWriter sw = new StringWriter();
                    legend.writeAll(DotGraph.this.legend, sw);
                    this.out.printf("%s%n", sw.toString());
                }
                super.outputEndOfFile();
            }
        };
        sink.setDirected(true);
        sink.writeAll(this.graph, writer);
    }

    public static DotGraph readDot(Reader reader) throws IOException {
        String content;
        String sentinel = "label=<";
        String replacement = "label=\"<";
        String ending = ">];";
        String endingReplacement = ">\"];";
        try (BufferedReader br = new BufferedReader(reader);
             StringWriter writer = new StringWriter();){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith(LABEL)) continue;
                int i = line.indexOf(sentinel);
                if (i != -1) {
                    writer.append(line.substring(0, i));
                    writer.append(replacement);
                    writer.append(line.substring(i + sentinel.length(), line.length() - ending.length()));
                    writer.append(endingReplacement);
                } else {
                    if (line.startsWith("subgraph")) {
                        writer.append("}");
                        break;
                    }
                    writer.append(line);
                }
                writer.append("\n");
            }
            content = writer.toString();
        }
        FileSourceDOT source = new FileSourceDOT();
        DotGraph graph = new DotGraph(null){};
        source.addSink((Sink)graph.graph);
        try (StringReader sr = new StringReader(content);){
            source.readAll((Reader)sr);
        }
        catch (Exception e) {
            System.out.println();
        }
        return graph;
    }

    private static final class Legend {
        private final Graph graph = new MultiGraph("legend");

        private Legend() {
            Node l = this.graph.addNode("legend");
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append("<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" cellborder=\"0\">");
            builder.append("<tr><td align=\"right\">node border&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("gray");
            builder.append("\">");
            builder.append("gray");
            builder.append("</font>, single</td></tr>");
            builder.append("<tr><td align=\"right\">entrypoint border&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("black");
            builder.append("\">");
            builder.append("black");
            builder.append("</font>, single</td></tr>");
            builder.append("<tr><td align=\"right\">exitpoint border&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("black");
            builder.append("\">");
            builder.append("black");
            builder.append("</font>, double</td></tr>");
            builder.append("<tr><td align=\"right\">sequential edge&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("black");
            builder.append("\">");
            builder.append("black");
            builder.append("</font>, solid</td></tr>");
            builder.append("<tr><td align=\"right\">true edge&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append(DotGraph.COLOR_BLUE);
            builder.append("\">");
            builder.append(DotGraph.COLOR_BLUE);
            builder.append("</font>, ");
            builder.append(DotGraph.CONDITIONAL_EDGE_STYLE);
            builder.append("</td></tr>");
            builder.append("<tr><td align=\"right\">false edge&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append(DotGraph.COLOR_RED);
            builder.append("\">");
            builder.append(DotGraph.COLOR_RED);
            builder.append("</font>, ");
            builder.append(DotGraph.CONDITIONAL_EDGE_STYLE);
            builder.append("</td></tr>");
            builder.append("</table>");
            builder.append(">");
            l.setAttribute(DotGraph.LABEL, new Object[]{builder.toString()});
        }
    }

    private class LegendClusterSink
    extends CustomDotSink {
        private LegendClusterSink() {
        }

        @Override
        protected void outputHeader() throws IOException {
            this.out = (PrintWriter)this.output;
            this.out.printf("%s {%n", "subgraph cluster_legend");
            this.out.printf("\tlabel=\"Legend\";%n", new Object[0]);
            this.out.printf("\tstyle=dotted;%n", new Object[0]);
            this.out.printf("\tnode [shape=plaintext];%n", new Object[0]);
        }
    }

    private class CustomDotSink
    extends FileSinkDOT {
        private CustomDotSink() {
        }

        protected void outputHeader() throws IOException {
            this.out = (PrintWriter)this.output;
            this.out.printf("%s {%n", "digraph");
            if (DotGraph.this.title != null) {
                this.out.printf("\tlabelloc=\"t\";%n", new Object[0]);
                this.out.printf("\tlabel=\"" + DotGraph.this.title + "\";%n", new Object[0]);
            }
        }

        protected String outputAttribute(String key, Object value, boolean first) {
            boolean quote = true;
            if (value instanceof Number || key.equals(DotGraph.LABEL)) {
                quote = false;
            }
            String quoting = quote ? "\"" : "";
            return String.format("%s%s=%s%s%s", first ? "" : ",", key, quoting, value, quoting);
        }

        protected String outputAttributes(Element e) {
            String result;
            if (e.getAttributeCount() == 0) {
                return "";
            }
            HashMap attrs = new HashMap();
            e.attributeKeys().forEach(key -> attrs.put(key, this.outputAttribute((String)key, e.getAttribute(key), true)));
            StringBuilder buffer = new StringBuilder("[");
            for (Map.Entry entry : attrs.entrySet()) {
                if (((String)entry.getKey()).equals(DotGraph.LABEL)) continue;
                buffer.append((String)entry.getValue()).append(",");
            }
            if (attrs.containsKey(DotGraph.LABEL)) {
                buffer.append((String)attrs.get(DotGraph.LABEL));
            }
            if ((result = buffer.toString()).endsWith(",")) {
                result = result.substring(0, result.length() - 1);
            }
            return result + "]";
        }
    }
}

