/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.logging;

import it.unive.lisa.logging.Counter;
import java.util.Iterator;

final class CountingIterable<E>
implements Iterable<E> {
    private final Iterator<E> iterator;

    CountingIterable(Iterable<E> iterable, final Counter counter) {
        final Iterator<E> it = iterable.iterator();
        this.iterator = new Iterator<E>(){

            @Override
            public boolean hasNext() {
                if (it.hasNext()) {
                    return true;
                }
                counter.off();
                return false;
            }

            @Override
            public E next() {
                if (!counter.isLogging()) {
                    counter.on();
                }
                counter.count();
                return it.next();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }
}

