/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.callgraph;

import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.interprocedural.callgraph.CallGraphEdge;
import it.unive.lisa.interprocedural.callgraph.CallGraphNode;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.workset.VisitOnceFIFOWorkingSet;
import it.unive.lisa.util.datastructures.graph.BaseGraph;
import it.unive.lisa.util.datastructures.graph.algorithms.SCCs;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CallGraph
extends BaseGraph<CallGraph, CallGraphNode, CallGraphEdge> {
    public void init(Application app) throws CallGraphConstructionException {
        this.entrypoints.clear();
        this.adjacencyMatrix.clear();
    }

    public abstract Call resolve(UnresolvedCall var1, Set<Type>[] var2, SymbolAliasing var3) throws CallResolutionException;

    public abstract void registerCall(CFGCall var1);

    public abstract Collection<Call> getCallSites(CodeMember var1);

    public Collection<Call> getCallSites(Collection<? extends CodeMember> cms) {
        HashSet<Call> result = new HashSet<Call>();
        cms.forEach(cm -> this.getCallSites((CodeMember)cm).stream().forEach(result::add));
        return result;
    }

    public Collection<CodeMember> getCallers(Collection<? extends CodeMember> cms) {
        HashSet<CodeMember> result = new HashSet<CodeMember>();
        cms.forEach(cm -> this.getCallers((CodeMember)cm).stream().forEach(result::add));
        return result;
    }

    public Collection<CodeMember> getCallersTransitively(CodeMember cm) {
        VisitOnceFIFOWorkingSet ws = VisitOnceFIFOWorkingSet.mk();
        this.getCallers(cm).stream().forEach(ws::push);
        while (!ws.isEmpty()) {
            this.getCallers((CodeMember)ws.pop()).stream().forEach(ws::push);
        }
        return ws.getSeen();
    }

    public Collection<CodeMember> getCallersTransitively(Collection<? extends CodeMember> cms) {
        VisitOnceFIFOWorkingSet ws = VisitOnceFIFOWorkingSet.mk();
        cms.forEach(cm -> this.getCallers((CodeMember)cm).stream().forEach(ws::push));
        while (!ws.isEmpty()) {
            this.getCallers((CodeMember)ws.pop()).stream().forEach(ws::push);
        }
        return ws.getSeen();
    }

    public Collection<CodeMember> getCallees(Collection<? extends CodeMember> cms) {
        HashSet<CodeMember> result = new HashSet<CodeMember>();
        cms.forEach(cm -> this.getCallees((CodeMember)cm).stream().forEach(result::add));
        return result;
    }

    public Collection<CodeMember> getCalleesTransitively(CodeMember cm) {
        VisitOnceFIFOWorkingSet ws = VisitOnceFIFOWorkingSet.mk();
        this.getCallees(cm).stream().forEach(ws::push);
        while (!ws.isEmpty()) {
            this.getCallees((CodeMember)ws.pop()).stream().forEach(ws::push);
        }
        return ws.getSeen();
    }

    public Collection<CodeMember> getCalleesTransitively(Collection<? extends CodeMember> cms) {
        VisitOnceFIFOWorkingSet ws = VisitOnceFIFOWorkingSet.mk();
        cms.forEach(cm -> this.getCallees((CodeMember)cm).stream().forEach(ws::push));
        while (!ws.isEmpty()) {
            this.getCallees((CodeMember)ws.pop()).stream().forEach(ws::push);
        }
        return ws.getSeen();
    }

    public Collection<CodeMember> getCallees(CodeMember cm) {
        return this.followersOf(new CallGraphNode(this, cm)).stream().map(CallGraphNode::getCodeMember).collect(Collectors.toList());
    }

    public Collection<CodeMember> getCallers(CodeMember cm) {
        return this.predecessorsOf(new CallGraphNode(this, cm)).stream().map(CallGraphNode::getCodeMember).collect(Collectors.toList());
    }

    public Collection<Collection<CodeMember>> getRecursions() {
        Collection sccs = new SCCs().buildNonTrivial(this);
        return sccs.stream().map(nodes -> nodes.stream().map(node -> node.getCodeMember()).collect(Collectors.toSet())).collect(Collectors.toSet());
    }

    public Collection<Collection<CodeMember>> getRecursionsContaining(CodeMember cm) {
        Collection sccs = new SCCs().buildNonTrivial(this);
        return sccs.stream().map(nodes -> nodes.stream().map(node -> node.getCodeMember()).collect(Collectors.toSet())).filter(members -> members.contains(cm)).collect(Collectors.toSet());
    }
}

