/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.callgraph;

import it.unive.lisa.analysis.symbols.Aliases;
import it.unive.lisa.analysis.symbols.NameSymbol;
import it.unive.lisa.analysis.symbols.QualifiedNameSymbol;
import it.unive.lisa.analysis.symbols.QualifierSymbol;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.interprocedural.callgraph.CallGraphEdge;
import it.unive.lisa.interprocedural.callgraph.CallGraphNode;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.cfg.AbstractCodeMember;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.CodeMemberDescriptor;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.VariableRef;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.MultiCall;
import it.unive.lisa.program.cfg.statement.call.NativeCall;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.ResolvedCall;
import it.unive.lisa.program.cfg.statement.call.TruncatedParamsCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.language.hierarchytraversal.HierarcyTraversalStrategy;
import it.unive.lisa.program.language.resolution.ParameterMatchingStrategy;
import it.unive.lisa.type.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseCallGraph
extends CallGraph {
    private static final Logger LOG = LogManager.getLogger(BaseCallGraph.class);
    private Application app;
    private final Map<CodeMember, Collection<Call>> callsites = new HashMap<CodeMember, Collection<Call>>();
    private final Map<UnresolvedCall, Map<List<Set<Type>>, Call>> resolvedCache = new IdentityHashMap<UnresolvedCall, Map<List<Set<Type>>, Call>>();

    @Override
    public void init(Application app) throws CallGraphConstructionException {
        super.init(app);
        this.app = app;
        this.callsites.clear();
        this.resolvedCache.clear();
    }

    @Override
    public void registerCall(CFGCall call) {
        if (call.getSource() != null) {
            return;
        }
        CallGraphNode source = new CallGraphNode(this, call.getCFG());
        if (!this.adjacencyMatrix.containsNode(source)) {
            this.addNode(source, this.app.getEntryPoints().contains(call.getCFG()));
        }
        for (CFG cfg : call.getTargetedCFGs()) {
            this.callsites.computeIfAbsent(cfg, cm -> new HashSet()).add(call);
            CallGraphNode t = new CallGraphNode(this, cfg);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, this.app.getEntryPoints().contains(call.getCFG()));
            }
            this.addEdge(new CallGraphEdge(source, t));
        }
    }

    @Override
    public Call resolve(UnresolvedCall call, Set<Type>[] types, SymbolAliasing aliasing) throws CallResolutionException {
        CallGraphNode t;
        List<Set<Type>> typeList = Arrays.asList(types);
        Call cached = (Call)this.resolvedCache.getOrDefault(call, Map.of()).get(typeList);
        if (cached != null) {
            return cached;
        }
        Expression[] params = call.getParameters();
        if (types == null || types.length != params.length) {
            throw new CallResolutionException("Cannot resolve call without runtime types");
        }
        if (Arrays.stream(types).anyMatch(rts -> rts == null || rts.isEmpty())) {
            types = Arrays.copyOf(types, types.length);
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != null && !types[i].isEmpty()) continue;
                types[i] = params[i].getStaticType().allInstances(call.getProgram().getTypes());
            }
        }
        HashSet<CFG> targets = new HashSet<CFG>();
        HashSet<NativeCFG> nativeTargets = new HashSet<NativeCFG>();
        HashSet<CFG> targetsNoRec = new HashSet<CFG>();
        HashSet<NativeCFG> nativeTargetsNoRec = new HashSet<NativeCFG>();
        switch (call.getCallType()) {
            case INSTANCE: {
                this.resolveInstance(call, types, targets, nativeTargets, aliasing);
                break;
            }
            case STATIC: {
                this.resolveNonInstance(call, types, targets, nativeTargets, aliasing);
                break;
            }
            default: {
                UnresolvedCall tempCall = new UnresolvedCall(call.getCFG(), call.getLocation(), Call.CallType.INSTANCE, call.getQualifier(), call.getTargetName(), call.getOrder(), params);
                this.resolveInstance(tempCall, types, targets, nativeTargets, aliasing);
                if (!(params[0] instanceof VariableRef)) {
                    LOG.debug(call + ": solving unknown-type calls as static-type requires the first parameter to be a reference to a variable, skipping");
                    break;
                }
                Expression[] truncatedParams = new Expression[params.length - 1];
                Set[] truncatedTypes = new Set[types.length - 1];
                System.arraycopy(params, 1, truncatedParams, 0, params.length - 1);
                System.arraycopy(types, 1, truncatedTypes, 0, types.length - 1);
                tempCall = new UnresolvedCall(call.getCFG(), call.getLocation(), Call.CallType.STATIC, ((VariableRef)params[0]).getName(), call.getTargetName(), call.getOrder(), truncatedParams);
                this.resolveNonInstance(tempCall, truncatedTypes, targetsNoRec, nativeTargetsNoRec, aliasing);
            }
        }
        CFGCall cfgcall = new CFGCall(call, targets);
        NativeCall nativecall = new NativeCall(call, nativeTargets);
        TruncatedParamsCall cfgcallnorec = new CFGCall(call, targetsNoRec).removeFirstParameter();
        TruncatedParamsCall nativecallnorec = new NativeCall(call, nativeTargetsNoRec).removeFirstParameter();
        Call resolved = this.noTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new OpenCall(call) : (this.onlyNonRewritingCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? cfgcall : (this.onlyNonRewritingNativeTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? nativecall : (this.onlyNonRewritingTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, cfgcall, nativecall) : (this.onlyRewritingCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? cfgcallnorec : (this.onlyRewritingNativeTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? nativecallnorec : (this.onlyRewritingTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, cfgcallnorec, nativecallnorec) : (this.onlyCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, cfgcall, cfgcallnorec) : (this.onlyNativeCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, nativecall, nativecallnorec) : new MultiCall(call, cfgcall, cfgcallnorec, nativecall, nativecallnorec)))))))));
        resolved.setSource(call);
        this.resolvedCache.computeIfAbsent(call, c -> new HashMap()).put(typeList, resolved);
        CallGraphNode source = new CallGraphNode(this, call.getCFG());
        if (!this.adjacencyMatrix.containsNode(source)) {
            this.addNode(source, this.app.getEntryPoints().contains(call.getCFG()));
        }
        for (CFG cFG : targets) {
            t = new CallGraphNode(this, cFG);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, this.app.getEntryPoints().contains(call.getCFG()));
            }
            this.addEdge(new CallGraphEdge(source, t));
            this.callsites.computeIfAbsent(cFG, cm -> new HashSet()).add(call);
        }
        for (NativeCFG nativeCFG : nativeTargets) {
            t = new CallGraphNode(this, nativeCFG);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, false);
            }
            this.addEdge(new CallGraphEdge(source, t));
            this.callsites.computeIfAbsent(nativeCFG, cm -> new HashSet()).add(call);
        }
        LOG.trace(call + " [" + call.getLocation() + "] has been resolved to: " + ((ResolvedCall)((Object)resolved)).getTargets());
        return resolved;
    }

    private boolean onlyNativeCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && !nativeTargets.isEmpty() && targetsNoRec.isEmpty() && !nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return !targets.isEmpty() && nativeTargets.isEmpty() && !targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyRewritingTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && !targetsNoRec.isEmpty() && !nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyRewritingNativeTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && targetsNoRec.isEmpty() && !nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyRewritingCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && !targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyNonRewritingTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return !targets.isEmpty() && !nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyNonRewritingNativeTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && !nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyNonRewritingCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return !targets.isEmpty() && nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean noTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    public void resolveNonInstance(UnresolvedCall call, Set<Type>[] types, Collection<CFG> targets, Collection<NativeCFG> natives, SymbolAliasing aliasing) throws CallResolutionException {
        for (CodeMember cm : this.app.getAllCodeCodeMembers()) {
            this.checkMember(call, types, targets, natives, aliasing, cm, false);
        }
    }

    public void resolveInstance(UnresolvedCall call, Set<Type>[] types, Collection<CFG> targets, Collection<NativeCFG> natives, SymbolAliasing aliasing) throws CallResolutionException {
        if (call.getParameters().length == 0) {
            throw new CallResolutionException("An instance call should have at least one parameter to be used as the receiver of the call");
        }
        Expression receiver = call.getParameters()[0];
        for (Type recType : this.getPossibleTypesOfReceiver(receiver, types[0])) {
            CompilationUnit unit;
            if (recType.isUnitType()) {
                unit = recType.asUnitType().getUnit();
            } else {
                if (!recType.isPointerType() || !recType.asPointerType().getInnerType().isUnitType()) continue;
                unit = recType.asPointerType().getInnerType().asUnitType().getUnit();
            }
            HashSet<CompilationUnit> seen = new HashSet<CompilationUnit>();
            HierarcyTraversalStrategy strategy = call.getProgram().getFeatures().getTraversalStrategy();
            for (CompilationUnit cu : strategy.traverse(call, unit)) {
                if (!seen.add(cu)) continue;
                for (CodeMember cm : cu.getInstanceCodeMembers(false)) {
                    this.checkMember(call, types, targets, natives, aliasing, cm, true);
                }
            }
        }
    }

    public void checkMember(UnresolvedCall call, Set<Type>[] types, Collection<CFG> targets, Collection<NativeCFG> natives, SymbolAliasing aliasing, CodeMember cm, boolean instance) {
        CodeMemberDescriptor descr = cm.getDescriptor();
        if (instance != descr.isInstance() || cm instanceof AbstractCodeMember) {
            return;
        }
        String qualifier = descr.getUnit().getName();
        String name = descr.getName();
        boolean add = false;
        if (aliasing != null) {
            Aliases nAlias = (Aliases)aliasing.getState(new NameSymbol(name));
            Aliases qAlias = (Aliases)aliasing.getState(new QualifierSymbol(qualifier));
            Aliases qnAlias = (Aliases)aliasing.getState(new QualifiedNameSymbol(qualifier, name));
            if (!qnAlias.isEmpty()) {
                for (QualifiedNameSymbol qualifiedNameSymbol : qnAlias.castElements(QualifiedNameSymbol.class)) {
                    if (!this.matchCodeMemberName(call, qualifiedNameSymbol.getQualifier(), qualifiedNameSymbol.getName())) continue;
                    add = true;
                    break;
                }
            }
            if (!add && !qAlias.isEmpty()) {
                for (QualifierSymbol qualifierSymbol : qAlias.castElements(QualifierSymbol.class)) {
                    if (!this.matchCodeMemberName(call, qualifierSymbol.getQualifier(), name)) continue;
                    add = true;
                    break;
                }
            }
            if (!add && !nAlias.isEmpty()) {
                for (NameSymbol nameSymbol : nAlias.castElements(NameSymbol.class)) {
                    if (!this.matchCodeMemberName(call, qualifier, nameSymbol.getName())) continue;
                    add = true;
                    break;
                }
            }
        }
        if (!add) {
            add = this.matchCodeMemberName(call, qualifier, name);
        }
        ParameterMatchingStrategy strategy = call.getProgram().getFeatures().getMatchingStrategy();
        if (add && strategy.matches(call, descr.getFormals(), call.getParameters(), types)) {
            if (cm instanceof CFG) {
                targets.add((CFG)cm);
            } else {
                natives.add((NativeCFG)cm);
            }
        }
    }

    public boolean matchCodeMemberName(UnresolvedCall call, String qualifier, String name) {
        if (!name.equals(call.getTargetName())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)call.getQualifier())) {
            return true;
        }
        return qualifier.equals(call.getQualifier());
    }

    public abstract Collection<Type> getPossibleTypesOfReceiver(Expression var1, Set<Type> var2) throws CallResolutionException;

    @Override
    public Collection<Call> getCallSites(CodeMember cm) {
        return this.callsites.getOrDefault(cm, Collections.emptyList());
    }
}

