/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.FixpointResults;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.MetaVariableCreator;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.MultiCall;
import it.unive.lisa.program.cfg.statement.call.NativeCall;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.TruncatedParamsCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public interface InterproceduralAnalysis<A extends AbstractState<A>> {
    public boolean needsCallGraph();

    public void init(Application var1, CallGraph var2, OpenCallPolicy var3) throws InterproceduralAnalysisException;

    public void fixpoint(AnalysisState<A> var1, Class<? extends WorkingSet<Statement>> var2, FixpointConfiguration var3) throws FixpointException;

    public Collection<AnalyzedCFG<A>> getAnalysisResultsOf(CFG var1);

    public AnalysisState<A> getAbstractResultOf(CFGCall var1, AnalysisState<A> var2, ExpressionSet[] var3, StatementStore<A> var4) throws SemanticException;

    public AnalysisState<A> getAbstractResultOf(OpenCall var1, AnalysisState<A> var2, ExpressionSet[] var3, StatementStore<A> var4) throws SemanticException;

    public Call resolve(UnresolvedCall var1, Set<Type>[] var2, SymbolAliasing var3) throws CallResolutionException;

    public FixpointResults<A> getFixpointResults();

    default public Pair<AnalysisState<A>, ExpressionSet[]> scope(AnalysisState<A> state, ScopeToken scope, ExpressionSet[] actuals) throws SemanticException {
        ExpressionSet[] locals = new ExpressionSet[actuals.length];
        Object callState = state.pushScope(scope);
        for (int i = 0; i < actuals.length; ++i) {
            locals[i] = actuals[i].pushScope(scope);
        }
        return Pair.of((Object)callState, (Object)locals);
    }

    default public AnalysisState<A> unscope(CFGCall call, ScopeToken scope, AnalysisState<A> state) throws SemanticException {
        if (this.returnsVoid(call, state)) {
            return state.popScope(scope);
        }
        Identifier meta = (Identifier)call.getMetaVariable().pushScope(scope);
        if (state.getComputedExpressions().isEmpty()) {
            PushInv inv = new PushInv(meta.getStaticType(), call.getLocation());
            return state.assign(meta, (SymbolicExpression)inv, (ProgramPoint)call).popScope(scope);
        }
        AnalysisState<A> tmp = state.bottom();
        for (SymbolicExpression ret : state.getComputedExpressions()) {
            tmp = tmp.lub(state.assign(meta, ret, (ProgramPoint)call));
        }
        return tmp.popScope(scope);
    }

    default public boolean returnsVoid(Call call, AnalysisState<A> returned) {
        MultiCall multicall;
        NativeCall nativecall;
        CFGCall cfgcall;
        Collection<Object> targets;
        if (call.getStaticType().isVoidType()) {
            return true;
        }
        if (!call.getStaticType().isUntyped()) {
            return false;
        }
        if (call instanceof CFGCall && !(targets = (cfgcall = (CFGCall)call).getTargetedCFGs()).isEmpty()) {
            return !((CFG)targets.iterator().next()).getNormalExitpoints().stream().anyMatch(st -> st instanceof MetaVariableCreator);
        }
        if (call instanceof NativeCall && !(targets = (nativecall = (NativeCall)call).getTargetedConstructs()).isEmpty()) {
            return false;
        }
        if (call instanceof TruncatedParamsCall) {
            return this.returnsVoid(((TruncatedParamsCall)call).getInnerCall(), returned);
        }
        if (call instanceof MultiCall && !(targets = (multicall = (MultiCall)call).getCalls()).isEmpty()) {
            return this.returnsVoid((Call)targets.iterator().next(), returned);
        }
        if (returned != null) {
            if (returned.getComputedExpressions().isEmpty()) {
                return true;
            }
            if (returned.getComputedExpressions().size() == 1 && returned.getComputedExpressions().iterator().next() instanceof Skip) {
                return true;
            }
        }
        return false;
    }
}

