/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.interprocedural.CFGResults;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.program.cfg.CFG;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class FixpointResults<A extends AbstractState<A>>
extends FunctionalLattice<FixpointResults<A>, CFG, CFGResults<A>> {
    public FixpointResults(CFGResults<A> lattice) {
        super(lattice);
    }

    private FixpointResults(CFGResults<A> lattice, Map<CFG, CFGResults<A>> function) {
        super(lattice, function);
    }

    public Pair<Boolean, AnalyzedCFG<A>> putResult(CFG cfg, ScopeId token, AnalyzedCFG<A> result) throws SemanticException {
        if (this.function == null) {
            this.function = this.mkNewFunction(null, false);
        }
        CFGResults res = this.function.computeIfAbsent(cfg, c -> new CFGResults(result.top()));
        return res.putResult(token, result);
    }

    public boolean contains(CFG cfg) {
        return this.function != null && this.function.containsKey(cfg);
    }

    public CFGResults<A> get(CFG cfg) {
        return this.function == null ? null : (CFGResults)this.function.get(cfg);
    }

    @Override
    public FixpointResults<A> top() {
        return new FixpointResults<A>(((CFGResults)this.lattice).top());
    }

    @Override
    public FixpointResults<A> bottom() {
        return new FixpointResults<A>(((CFGResults)this.lattice).bottom());
    }

    public void forget(CFG cfg) {
        if (this.function == null) {
            return;
        }
        this.function.remove(cfg);
        if (this.function.isEmpty()) {
            this.function = null;
        }
    }

    @Override
    public FixpointResults<A> mk(CFGResults<A> lattice, Map<CFG, CFGResults<A>> function) {
        return new FixpointResults<A>(lattice, function);
    }

    @Override
    public CFGResults<A> stateOfUnknown(CFG key) {
        return ((CFGResults)this.lattice).bottom();
    }
}

