/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.interprocedural.ScopeId;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CFGResults<A extends AbstractState<A>>
extends FunctionalLattice<CFGResults<A>, ScopeId, AnalyzedCFG<A>> {
    public CFGResults(AnalyzedCFG<A> lattice) {
        super(lattice);
    }

    private CFGResults(AnalyzedCFG<A> lattice, Map<ScopeId, AnalyzedCFG<A>> function) {
        super(lattice, function);
    }

    public Pair<Boolean, AnalyzedCFG<A>> putResult(ScopeId token, AnalyzedCFG<A> result) throws SemanticException {
        if (this.function == null) {
            this.function = this.mkNewFunction(null, false);
            this.function.put(token, result);
            return Pair.of((Object)false, result);
        }
        AnalyzedCFG previousResult = (AnalyzedCFG)this.function.get(token);
        if (previousResult == null) {
            this.function.put(token, result);
            return Pair.of((Object)false, result);
        }
        if (previousResult.lessOrEqual(result)) {
            if (result.lessOrEqual(previousResult)) {
                return Pair.of((Object)false, (Object)previousResult);
            }
            this.function.put(token, result);
            return Pair.of((Object)true, result);
        }
        if (result.lessOrEqual(previousResult)) {
            return Pair.of((Object)false, (Object)previousResult);
        }
        AnalyzedCFG<A> lub = previousResult.lub(result);
        this.function.put(token, lub);
        return Pair.of((Object)true, lub);
    }

    public boolean contains(ScopeId token) {
        return this.function != null && this.function.containsKey(token);
    }

    public AnalyzedCFG<A> get(ScopeId token) {
        return this.function == null ? null : (AnalyzedCFG)this.function.get(token);
    }

    public Collection<AnalyzedCFG<A>> getAll() {
        return this.function == null ? Collections.emptySet() : this.function.values();
    }

    @Override
    public CFGResults<A> top() {
        return new CFGResults<A>(((AnalyzedCFG)this.lattice).top());
    }

    @Override
    public CFGResults<A> bottom() {
        return new CFGResults<A>(((AnalyzedCFG)this.lattice).bottom());
    }

    @Override
    public CFGResults<A> mk(AnalyzedCFG<A> lattice, Map<ScopeId, AnalyzedCFG<A>> function) {
        return new CFGResults<A>(lattice, function);
    }

    @Override
    public AnalyzedCFG<A> stateOfUnknown(ScopeId key) {
        return ((AnalyzedCFG)this.lattice).bottom();
    }
}

