/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.conf;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.checks.semantic.SemanticCheck;
import it.unive.lisa.checks.syntactic.SyntacticCheck;
import it.unive.lisa.conf.BaseConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.WorstCasePolicy;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.collections.CollectionUtilities;
import it.unive.lisa.util.collections.workset.DuplicateFreeFIFOWorkingSet;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;

public class LiSAConfiguration
extends BaseConfiguration {
    public static final int DEFAULT_WIDENING_THRESHOLD = 5;
    public static final int DEFAULT_GLB_THRESHOLD = 5;
    public final Collection<SyntacticCheck> syntacticChecks = new HashSet<SyntacticCheck>();
    public final Collection<SemanticCheck<?>> semanticChecks = new HashSet();
    public CallGraph callGraph;
    public InterproceduralAnalysis<?> interproceduralAnalysis;
    public AbstractState<?> abstractState;
    public GraphType analysisGraphs = GraphType.NONE;
    public boolean serializeInputs;
    public boolean serializeResults;
    public boolean jsonOutput;
    public String workdir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    public int wideningThreshold = 5;
    public int recursionWideningThreshold = 5;
    public int glbThreshold = 5;
    public DescendingPhaseType descendingPhaseType = DescendingPhaseType.NONE;
    public Class<?> fixpointWorkingSet = DuplicateFreeFIFOWorkingSet.class;
    public OpenCallPolicy openCallPolicy = WorstCasePolicy.INSTANCE;
    public boolean optimize = false;
    public boolean useWideningPoints = true;
    public Predicate<Statement> hotspots = null;
    public boolean dumpForcesUnwinding = false;

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("LiSA configuration:");
        try {
            for (Field field : LiSAConfiguration.class.getFields()) {
                if (Modifier.isStatic(field.getModifiers()) || AbstractState.class.isAssignableFrom(field.getType()) || CallGraph.class.isAssignableFrom(field.getType()) || InterproceduralAnalysis.class.isAssignableFrom(field.getType())) continue;
                Object value = field.get(this);
                res.append("\n  ").append(field.getName());
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection coll = (Collection)value;
                    res.append(" (").append(coll.size()).append(")").append(coll.isEmpty() ? "" : ":");
                    for (Object element : coll) {
                        res.append("\n    ").append(element.getClass().getSimpleName());
                    }
                    continue;
                }
                if (Class.class.isAssignableFrom(field.getType())) {
                    res.append(": ").append(((Class)value).getSimpleName());
                    continue;
                }
                if (OpenCallPolicy.class.isAssignableFrom(field.getType())) {
                    res.append(": ").append(((OpenCallPolicy)value).getClass().getSimpleName());
                    continue;
                }
                if (Predicate.class.isAssignableFrom(field.getType())) {
                    res.append(": ").append(value == null ? "unset" : "set");
                    continue;
                }
                res.append(": ").append(String.valueOf(value));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Cannot access one of this class' public fields", e);
        }
        return res.toString();
    }

    public Map<String, String> toPropertyBag() {
        TreeMap<String, String> bag = new TreeMap<String, String>();
        try {
            for (Field field : LiSAConfiguration.class.getFields()) {
                if (Modifier.isStatic(field.getModifiers()) || AbstractState.class.isAssignableFrom(field.getType()) || CallGraph.class.isAssignableFrom(field.getType()) || InterproceduralAnalysis.class.isAssignableFrom(field.getType())) continue;
                Object value = field.get(this);
                String key = field.getName();
                String val = Collection.class.isAssignableFrom(field.getType()) ? (String)((Collection)value).stream().map(e -> e.getClass().getSimpleName()).sorted().collect(new CollectionUtilities.StringCollector(", ")) : (Class.class.isAssignableFrom(field.getType()) ? ((Class)value).getSimpleName() : (OpenCallPolicy.class.isAssignableFrom(field.getType()) ? ((OpenCallPolicy)value).getClass().getSimpleName() : (Predicate.class.isAssignableFrom(field.getType()) ? (value == null ? "unset" : "set") : String.valueOf(value))));
                bag.put(key, val);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e2) {
            throw new IllegalStateException("Cannot access one of this class' public fields", e2);
        }
        bag.put("workdir", FilenameUtils.separatorsToUnix((String)this.workdir));
        return bag;
    }

    public static enum DescendingPhaseType {
        NONE,
        GLB,
        NARROWING;

    }

    public static enum GraphType {
        NONE,
        HTML,
        HTML_WITH_SUBNODES,
        DOT,
        GRAPHML,
        GRAPHML_WITH_SUBNODES;

    }
}

