/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.warnings;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.checks.warnings.WarningWithLocation;
import it.unive.lisa.program.ClassUnit;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.Unit;
import org.apache.commons.lang3.StringUtils;

public class UnitWarning
extends WarningWithLocation {
    private final Unit unit;

    public UnitWarning(Unit unit, String message) {
        super(unit instanceof ClassUnit ? ((ClassUnit)unit).getLocation() : SyntheticLocation.INSTANCE, message);
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public int compareTo(Warning o) {
        int cmp = super.compareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        if (!(o instanceof UnitWarning)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        UnitWarning other = (UnitWarning)o;
        cmp = StringUtils.compare((String)this.unit.getName(), (String)other.unit.getName());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitWarning other = (UnitWarning)obj;
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    @Override
    public String getTag() {
        return "UNIT";
    }

    @Override
    public String toString() {
        return this.getLocationWithBrackets() + " on '" + this.unit.getName() + "': " + this.getTaggedMessage();
    }
}

