/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.warnings;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.checks.warnings.WarningWithLocation;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.Unit;
import org.apache.commons.lang3.StringUtils;

public class GlobalWarning
extends WarningWithLocation {
    private final Unit unit;
    private final Global global;

    public GlobalWarning(Unit unit, Global global, String message) {
        super(global.getLocation(), message);
        this.unit = unit;
        this.global = global;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Global getGlobal() {
        return this.global;
    }

    @Override
    public int compareTo(Warning o) {
        int cmp = super.compareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        if (!(o instanceof GlobalWarning)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        GlobalWarning other = (GlobalWarning)o;
        cmp = StringUtils.compare((String)this.unit.getName(), (String)other.unit.getName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = StringUtils.compare((String)this.global.getName(), (String)other.global.getName());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.global == null ? 0 : this.global.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalWarning other = (GlobalWarning)obj;
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.global == null ? other.global != null : !this.global.equals(other.global));
    }

    @Override
    public String getTag() {
        return "GLOBAL";
    }

    @Override
    public String toString() {
        return this.getLocationWithBrackets() + " on '" + this.unit.getName() + "::" + this.global.getName() + "': " + this.getTaggedMessage();
    }
}

