/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.warnings;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.checks.warnings.WarningWithLocation;
import it.unive.lisa.program.cfg.CodeMemberDescriptor;
import org.apache.commons.lang3.StringUtils;

public class CFGDescriptorWarning
extends WarningWithLocation {
    private final CodeMemberDescriptor descriptor;

    public CFGDescriptorWarning(CodeMemberDescriptor descriptor, String message) {
        super(descriptor.getLocation(), message);
        this.descriptor = descriptor;
    }

    public CodeMemberDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int compareTo(Warning o) {
        int cmp = super.compareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        if (!(o instanceof CFGDescriptorWarning)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        CFGDescriptorWarning other = (CFGDescriptorWarning)o;
        cmp = StringUtils.compare((String)this.descriptor.toString(), (String)other.descriptor.toString());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFGDescriptorWarning other = (CFGDescriptorWarning)obj;
        return !(this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor));
    }

    @Override
    public String getTag() {
        return "DESCRIPTOR";
    }

    @Override
    public String toString() {
        return this.getLocationWithBrackets() + " on '" + this.descriptor.getFullSignatureWithParNames() + "': " + this.getTaggedMessage();
    }
}

