/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.semantic;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.checks.syntactic.CheckTool;
import it.unive.lisa.conf.LiSAConfiguration;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.util.file.FileManager;
import java.util.Collection;
import java.util.Map;

public class CheckToolWithAnalysisResults<A extends AbstractState<A>>
extends CheckTool {
    private final Map<CFG, Collection<AnalyzedCFG<A>>> results;
    private final CallGraph callgraph;

    public CheckToolWithAnalysisResults(LiSAConfiguration configuration, FileManager fileManager, Map<CFG, Collection<AnalyzedCFG<A>>> results, CallGraph callgraph) {
        super(configuration, fileManager);
        this.results = results;
        this.callgraph = callgraph;
    }

    public CheckToolWithAnalysisResults(CheckTool other, Map<CFG, Collection<AnalyzedCFG<A>>> results, CallGraph callgraph) {
        super(other);
        this.results = results;
        this.callgraph = callgraph;
    }

    public Collection<AnalyzedCFG<A>> getResultOf(CFG cfg) {
        return this.results.get(cfg);
    }

    public CallGraph getCallGraph() {
        return this.callgraph;
    }

    public Collection<CodeMember> getCallers(CodeMember cm) {
        return this.callgraph.getCallers(cm);
    }

    public Collection<CodeMember> getCallees(CodeMember cm) {
        return this.callgraph.getCallees(cm);
    }

    public Collection<Call> getCallSites(CodeMember cm) {
        return this.callgraph.getCallSites(cm);
    }

    public Call getResolvedVersion(UnresolvedCall call, AnalyzedCFG<A> result) throws SemanticException {
        StatementStore<A> store = new StatementStore<A>(result.getEntryState().bottom());
        for (Expression e : call.getParameters()) {
            store.put(e, result.getAnalysisStateAfter(e));
        }
        try {
            return this.callgraph.resolve(call, call.parameterTypes(store), null);
        }
        catch (CallResolutionException e) {
            return null;
        }
    }
}

