/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks;

import it.unive.lisa.checks.Check;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChecksExecutor {
    private static final Logger LOG = LogManager.getLogger(ChecksExecutor.class);

    private ChecksExecutor() {
    }

    public static <C extends Check<T>, T> void executeAll(T tool, Application app, Iterable<C> checks) {
        checks.forEach(c -> c.beforeExecution(tool));
        for (Program p : app.getPrograms()) {
            ChecksExecutor.visitProgram(tool, p, checks);
        }
        checks.forEach(c -> c.afterExecution(tool));
    }

    private static <T, C extends Check<T>> void visitProgram(T tool, Program program, Iterable<C> checks) {
        for (Global global : IterationLogger.iterate(LOG, program.getGlobals(), "Analyzing program globals...", "Globals")) {
            checks.forEach(c -> c.visitGlobal(tool, program, global, false));
        }
        for (CodeMember cm : IterationLogger.iterate(LOG, program.getCodeMembers(), "Analyzing program cfgs...", "CFGs")) {
            if (!(cm instanceof CFG)) continue;
            checks.forEach(c -> ((CFG)cm).accept(c, tool));
        }
        for (Unit unit : IterationLogger.iterate(LOG, program.getUnits(), "Analyzing compilation units...", "Units")) {
            checks.forEach(c -> ChecksExecutor.visitUnit(tool, unit, c));
        }
    }

    private static <C extends Check<T>, T> void visitUnit(T tool, Unit unit, C c) {
        if (!c.visitUnit(tool, unit)) {
            return;
        }
        for (Global global : unit.getGlobals()) {
            c.visitGlobal(tool, unit, global, false);
        }
        if (unit instanceof CompilationUnit) {
            for (Global global : ((CompilationUnit)unit).getInstanceGlobals(false)) {
                c.visitGlobal(tool, unit, global, true);
            }
        }
        for (CodeMember cm : unit.getCodeMembers()) {
            if (!(cm instanceof CFG)) continue;
            ((CFG)cm).accept(c, tool);
        }
        if (unit instanceof CompilationUnit) {
            for (CFG cfg : ((CompilationUnit)unit).getInstanceCFGs(false)) {
                cfg.accept(c, tool);
            }
        }
    }
}

