/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.value;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.value.ValueOracle;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;

public interface ValueDomain<D extends ValueDomain<D>>
extends ValueOracle,
SemanticDomain<D, ValueExpression, Identifier>,
Lattice<D> {
    default public D applyReplacement(HeapSemanticOperation.HeapReplacement r, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop() || this.isBottom() || r.getSources().isEmpty()) {
            return (D)this;
        }
        ValueDomain result = this;
        ValueDomain lub = (ValueDomain)this.bottom();
        for (Identifier source : r.getSources()) {
            ValueDomain partial = result;
            for (Identifier target : r.getTargets()) {
                partial = (ValueDomain)partial.assign(target, source, pp, oracle);
            }
            lub = lub.lub(partial);
        }
        return (D)((ValueDomain)lub.forgetIdentifiers(r.getIdsToForget()));
    }
}

