/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.type;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.type.TypeOracle;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;

public interface TypeDomain<T extends TypeDomain<T>>
extends TypeOracle,
ValueDomain<T> {
    @Override
    default public T applyReplacement(HeapSemanticOperation.HeapReplacement r, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop() || this.isBottom() || r.getSources().isEmpty()) {
            return (T)this;
        }
        TypeDomain result = this;
        TypeDomain lub = (TypeDomain)this.bottom();
        for (Identifier source : r.getSources()) {
            TypeDomain partial = result;
            for (Identifier target : r.getTargets()) {
                partial = (TypeDomain)partial.assign(target, source, pp, oracle);
            }
            lub = lub.lub(partial);
        }
        return (T)((TypeDomain)lub.forgetIdentifiers(r.getIdsToForget()));
    }
}

