/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.value;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalTypeDomain;
import it.unive.lisa.analysis.type.TypeDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeEnvironment<T extends NonRelationalTypeDomain<T>>
extends Environment<TypeEnvironment<T>, ValueExpression, T>
implements TypeDomain<TypeEnvironment<T>> {
    public TypeEnvironment(T domain) {
        super(domain);
    }

    public TypeEnvironment(T domain, Map<Identifier, T> function) {
        super(domain, function);
    }

    @Override
    public TypeEnvironment<T> mk(T lattice, Map<Identifier, T> function) {
        return new TypeEnvironment<T>(lattice, function);
    }

    @Override
    public TypeEnvironment<T> top() {
        return this.isTop() ? this : new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).top(), (Map<Identifier, NonRelationalTypeDomain>)null);
    }

    @Override
    public TypeEnvironment<T> bottom() {
        return this.isBottom() ? this : new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).bottom(), (Map<Identifier, NonRelationalTypeDomain>)null);
    }

    @Override
    public Set<Type> getRuntimeTypesOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (!e.mightNeedRewriting() || e instanceof Identifier) {
            return ((NonRelationalTypeDomain)this.eval((ValueExpression)e, pp, oracle)).getRuntimeTypes();
        }
        ExpressionSet vexps = oracle.rewrite(e, pp, oracle);
        HashSet<Type> result = new HashSet<Type>();
        for (SymbolicExpression vexp : vexps) {
            result.addAll(((NonRelationalTypeDomain)this.eval((ValueExpression)vexp, pp, oracle)).getRuntimeTypes());
        }
        return result;
    }

    @Override
    public Type getDynamicTypeOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        Set<Type> types = this.getRuntimeTypesOf(e, pp, oracle);
        if (types.isEmpty()) {
            return Untyped.INSTANCE;
        }
        return Type.commonSupertype(types, Untyped.INSTANCE);
    }
}

