/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.value;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.NullConstant;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.LogicalAnd;
import it.unive.lisa.symbolic.value.operator.binary.LogicalOr;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeConv;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.LogicalNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.type.Type;
import java.util.Set;

public interface BaseNonRelationalValueDomain<T extends BaseNonRelationalValueDomain<T>>
extends BaseLattice<T>,
NonRelationalValueDomain<T> {
    @Override
    default public Satisfiability satisfies(ValueExpression expression, ValueEnvironment<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof Identifier) {
            return this.satisfiesAbstractValue((BaseNonRelationalValueDomain)environment.getState((Identifier)expression), pp, oracle);
        }
        if (expression instanceof NullConstant) {
            return this.satisfiesNullConstant(pp, oracle);
        }
        if (expression instanceof Constant) {
            return this.satisfiesNonNullConstant((Constant)expression, pp, oracle);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)expression;
            if (unary.getOperator() == LogicalNegation.INSTANCE) {
                return this.satisfies((ValueExpression)unary.getExpression(), environment, pp, oracle).negate();
            }
            T arg = this.eval((ValueExpression)unary.getExpression(), environment, pp, oracle);
            if (arg.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            return this.satisfiesUnaryExpression(unary.getOperator(), arg, pp, oracle);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() == LogicalAnd.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp, oracle).and(this.satisfies((ValueExpression)binary.getRight(), environment, pp, oracle));
            }
            if (binary.getOperator() == LogicalOr.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp, oracle).or(this.satisfies((ValueExpression)binary.getRight(), environment, pp, oracle));
            }
            T left = this.eval((ValueExpression)binary.getLeft(), environment, pp, oracle);
            if (left.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            T right = this.eval((ValueExpression)binary.getRight(), environment, pp, oracle);
            if (right.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            return this.satisfiesBinaryExpression(binary.getOperator(), left, right, pp, oracle);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            T left = this.eval((ValueExpression)ternary.getLeft(), environment, pp, oracle);
            if (left.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            T middle = this.eval((ValueExpression)ternary.getMiddle(), environment, pp, oracle);
            if (middle.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            T right = this.eval((ValueExpression)ternary.getRight(), environment, pp, oracle);
            if (right.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            return this.satisfiesTernaryExpression(ternary.getOperator(), left, middle, right, pp, oracle);
        }
        return Satisfiability.UNKNOWN;
    }

    @Override
    default public T eval(ValueExpression expression, ValueEnvironment<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)expression.accept(new EvaluationVisitor<BaseNonRelationalValueDomain>(this), environment, pp, oracle);
    }

    @Override
    default public boolean canProcess(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        if (expression instanceof PushInv) {
            return expression.getStaticType().isValueType();
        }
        Set<Type> rts = null;
        try {
            rts = oracle.getRuntimeTypesOf(expression, pp, oracle);
        }
        catch (SemanticException e) {
            return false;
        }
        if (rts == null || rts.isEmpty()) {
            return true;
        }
        return rts.stream().anyMatch(Type::isValueType);
    }

    default public T evalIdentifier(Identifier id, ValueEnvironment<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)environment.getState(id));
    }

    default public T evalSkip(Skip skip, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.bottom());
    }

    default public T evalPushAny(PushAny pushAny, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public T evalPushInv(PushInv pushInv, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.bottom());
    }

    default public T evalTypeConv(BinaryExpression conv, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)(oracle.getRuntimeTypesOf(conv, pp, oracle).isEmpty() ? (BaseNonRelationalValueDomain)this.bottom() : left);
    }

    default public T evalTypeCast(BinaryExpression cast, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)(oracle.getRuntimeTypesOf(cast, pp, oracle).isEmpty() ? (BaseNonRelationalValueDomain)this.bottom() : left);
    }

    default public T evalNullConstant(ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public T evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public T evalUnaryExpression(UnaryOperator operator, T arg, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public T evalBinaryExpression(BinaryOperator operator, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public T evalTernaryExpression(TernaryOperator operator, T left, T middle, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public T evalValueExpression(ValueExpression expression, T[] subExpressions, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    default public Satisfiability satisfiesAbstractValue(T value, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesNullConstant(ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesUnaryExpression(UnaryOperator operator, T arg, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesTernaryExpression(TernaryOperator operator, T left, T middle, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    @Override
    default public ValueEnvironment<T> assume(ValueEnvironment<T> environment, ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        Satisfiability sat = this.satisfies(expression, environment, src, oracle);
        if (sat == Satisfiability.NOT_SATISFIED) {
            return environment.bottom();
        }
        if (sat == Satisfiability.SATISFIED) {
            return environment;
        }
        if (expression instanceof UnaryExpression) {
            ValueExpression rewritten;
            UnaryExpression unary = (UnaryExpression)expression;
            if (unary.getOperator() == LogicalNegation.INSTANCE && (rewritten = unary.removeNegations()) != unary) {
                return this.assume(environment, rewritten, src, dest, oracle);
            }
            return this.assumeUnaryExpression(environment, unary.getOperator(), (ValueExpression)unary.getExpression(), src, dest, oracle);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() == LogicalAnd.INSTANCE) {
                return this.assume(environment, (ValueExpression)binary.getLeft(), src, dest, oracle).glb(this.assume(environment, (ValueExpression)binary.getRight(), src, dest, oracle));
            }
            if (binary.getOperator() == LogicalOr.INSTANCE) {
                return this.assume(environment, (ValueExpression)binary.getLeft(), src, dest, oracle).lub(this.assume(environment, (ValueExpression)binary.getRight(), src, dest, oracle));
            }
            return this.assumeBinaryExpression(environment, binary.getOperator(), (ValueExpression)binary.getLeft(), (ValueExpression)binary.getRight(), src, dest, oracle);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            return this.assumeTernaryExpression(environment, ternary.getOperator(), (ValueExpression)ternary.getLeft(), (ValueExpression)ternary.getMiddle(), (ValueExpression)ternary.getRight(), src, dest, oracle);
        }
        return environment;
    }

    default public ValueEnvironment<T> assumeTernaryExpression(ValueEnvironment<T> environment, TernaryOperator operator, ValueExpression left, ValueExpression middle, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return environment;
    }

    default public ValueEnvironment<T> assumeBinaryExpression(ValueEnvironment<T> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return environment;
    }

    default public ValueEnvironment<T> assumeUnaryExpression(ValueEnvironment<T> environment, UnaryOperator operator, ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return environment;
    }

    public static class EvaluationVisitor<T extends BaseNonRelationalValueDomain<T>>
    implements ExpressionVisitor<T> {
        private static final String CANNOT_PROCESS_ERROR = "Cannot process a heap expression with a non-relational value domain";
        private final T singleton;

        public EvaluationVisitor(T singleton) {
            this.singleton = singleton;
        }

        @Override
        public T visit(HeapExpression expression, T[] subExpressions, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(AccessChild expression, T receiver, T child, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(MemoryAllocation expression, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(HeapReference expression, T arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(HeapDereference expression, T arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(UnaryExpression expression, T arg, Object ... params) throws SemanticException {
            if (arg.isBottom()) {
                return arg;
            }
            return this.singleton.evalUnaryExpression(expression.getOperator(), arg, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(BinaryExpression expression, T left, T right, Object ... params) throws SemanticException {
            if (left.isBottom()) {
                return left;
            }
            if (right.isBottom()) {
                return right;
            }
            ProgramPoint pp = (ProgramPoint)params[1];
            SemanticOracle oracle = (SemanticOracle)params[2];
            if (expression.getOperator() == TypeCast.INSTANCE) {
                return this.singleton.evalTypeCast(expression, left, right, pp, oracle);
            }
            if (expression.getOperator() == TypeConv.INSTANCE) {
                return this.singleton.evalTypeConv(expression, left, right, pp, oracle);
            }
            return this.singleton.evalBinaryExpression(expression.getOperator(), left, right, pp, oracle);
        }

        @Override
        public T visit(TernaryExpression expression, T left, T middle, T right, Object ... params) throws SemanticException {
            if (left.isBottom()) {
                return left;
            }
            if (middle.isBottom()) {
                return middle;
            }
            if (right.isBottom()) {
                return right;
            }
            return this.singleton.evalTernaryExpression(expression.getOperator(), left, middle, right, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(Skip expression, Object ... params) throws SemanticException {
            return this.singleton.evalSkip(expression, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(PushAny expression, Object ... params) throws SemanticException {
            return this.singleton.evalPushAny(expression, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(PushInv expression, Object ... params) throws SemanticException {
            return this.singleton.evalPushInv(expression, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(Constant expression, Object ... params) throws SemanticException {
            if (expression instanceof NullConstant) {
                return this.singleton.evalNullConstant((ProgramPoint)params[1], (SemanticOracle)params[2]);
            }
            return this.singleton.evalNonNullConstant(expression, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(Identifier expression, Object ... params) throws SemanticException {
            return this.singleton.evalIdentifier(expression, (ValueEnvironment)params[0], (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public T visit(ValueExpression expression, T[] subExpressions, Object ... params) throws SemanticException {
            if (subExpressions != null) {
                for (T sub : subExpressions) {
                    if (!sub.isBottom()) continue;
                    return sub;
                }
            }
            return (T)this.singleton.evalValueExpression(expression, subExpressions, (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }
    }
}

