/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.inference;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.nonrelational.NonRelationalElement;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.representation.ObjectRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Map;

public interface InferredValue<T extends InferredValue<T>>
extends NonRelationalElement<T, ValueExpression, InferenceSystem<T>> {
    public InferredPair<T> eval(ValueExpression var1, InferenceSystem<T> var2, ProgramPoint var3, SemanticOracle var4) throws SemanticException;

    public static class InferredPair<T extends InferredValue<T>>
    implements BaseLattice<InferredPair<T>> {
        private final T domain;
        private final T inferred;
        private final T state;

        public InferredPair(T domain, T inferred, T state) {
            this.domain = domain;
            this.inferred = inferred;
            this.state = state;
        }

        public T getInferred() {
            return this.inferred;
        }

        public T getState() {
            return this.state;
        }

        @Override
        public InferredPair<T> top() {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.domain.top(), (InferredValue)this.domain.top());
        }

        @Override
        public boolean isTop() {
            return this.inferred.isTop() && this.state.isTop();
        }

        @Override
        public InferredPair<T> bottom() {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.domain.bottom(), (InferredValue)this.domain.bottom());
        }

        @Override
        public boolean isBottom() {
            return this.inferred.isBottom() && this.state.isBottom();
        }

        @Override
        public InferredPair<T> lubAux(InferredPair<T> other) throws SemanticException {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.inferred.lub(other.inferred), (InferredValue)this.state.lub(other.state));
        }

        @Override
        public InferredPair<T> glbAux(InferredPair<T> other) throws SemanticException {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.inferred.glb(other.inferred), (InferredValue)this.state.glb(other.state));
        }

        @Override
        public InferredPair<T> wideningAux(InferredPair<T> other) throws SemanticException {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.inferred.widening(other.inferred), (InferredValue)this.state.widening(other.state));
        }

        @Override
        public InferredPair<T> narrowingAux(InferredPair<T> other) throws SemanticException {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.inferred.narrowing(other.inferred), (InferredValue)this.state.narrowing(other.state));
        }

        @Override
        public boolean lessOrEqualAux(InferredPair<T> other) throws SemanticException {
            return this.inferred.lessOrEqual(other.inferred) && this.state.lessOrEqual(other.state);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            result = 31 * result + (this.inferred == null ? 0 : this.inferred.hashCode());
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InferredPair other = (InferredPair)obj;
            if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                return false;
            }
            if (this.inferred == null ? other.inferred != null : !this.inferred.equals(other.inferred)) {
                return false;
            }
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }

        @Override
        public String toString() {
            return this.representation().toString();
        }

        @Override
        public StructuredRepresentation representation() {
            return new ObjectRepresentation(Map.of("value", this.inferred.representation(), "state", this.state.representation()));
        }
    }
}

