/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.inference;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.VariableLift;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.representation.ObjectRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Map;

public class InferenceSystem<T extends InferredValue<T>>
extends VariableLift<InferenceSystem<T>, ValueExpression, T>
implements ValueDomain<InferenceSystem<T>> {
    private final T state;

    public InferenceSystem(T domain) {
        super(domain);
        this.state = (InferredValue)domain.bottom();
    }

    public InferenceSystem(InferenceSystem<T> other, T state) {
        this((InferredValue)other.lattice, other.function, (InferredValue)state);
    }

    public InferenceSystem(T domain, Map<Identifier, T> function, T state) {
        super(domain, function);
        this.state = state;
    }

    @Override
    public InferenceSystem<T> mk(T lattice, Map<Identifier, T> function) {
        return new InferenceSystem<T>(lattice, function, this.state);
    }

    @Override
    public InferenceSystem<T> assign(Identifier id, ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom() || !((InferredValue)this.lattice).canProcess(expression, pp, oracle)) {
            return this;
        }
        Map<Identifier, Object> func = this.mkNewFunction(this.function, false);
        InferredValue.InferredPair eval = ((InferredValue)this.lattice).eval(expression, this, pp, oracle);
        Object value = eval.getInferred();
        InferredValue v = (InferredValue)((InferredValue)this.lattice).fixedVariable(id, pp, oracle);
        if (!v.isBottom()) {
            value = v;
        }
        if (id.isWeak() && this.function != null && this.function.containsKey(id)) {
            value = value.lub((InferredValue)((InferredValue)this.getState(id)));
        }
        func.put(id, value);
        return new InferenceSystem<InferredValue>((InferredValue)this.lattice, (Map<Identifier, InferredValue>)func, (InferredValue)eval.getState());
    }

    public T getExecutionState() {
        return this.state;
    }

    @Override
    public InferenceSystem<T> smallStepSemantics(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this;
        }
        return new InferenceSystem<InferredValue>((InferredValue)this.lattice, this.function, (InferredValue)((InferredValue)this.lattice).eval(expression, this, pp, oracle).getState());
    }

    @Override
    public InferenceSystem<T> assume(ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this;
        }
        Satisfiability sat = ((InferredValue)this.lattice).satisfies(expression, this, src, oracle);
        if (sat == Satisfiability.NOT_SATISFIED) {
            return this.bottom();
        }
        if (sat == Satisfiability.SATISFIED) {
            return new InferenceSystem<InferredValue>((InferredValue)this.lattice, this.function, (InferredValue)((InferredValue)this.lattice).eval(expression, this, src, oracle).getState());
        }
        return ((InferredValue)this.lattice).assume(this, expression, src, dest, oracle);
    }

    public T eval(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return ((InferredValue)this.lattice).eval(expression, this, pp, oracle).getInferred();
    }

    @Override
    public InferenceSystem<T> top() {
        return new InferenceSystem<InferredValue>((InferredValue)((InferredValue)this.lattice).top(), null, (InferredValue)this.state.top());
    }

    @Override
    public InferenceSystem<T> bottom() {
        return new InferenceSystem<InferredValue>((InferredValue)((InferredValue)this.lattice).bottom(), null, (InferredValue)this.state.bottom());
    }

    @Override
    public boolean isTop() {
        return super.isTop() && this.state.isTop();
    }

    @Override
    public boolean isBottom() {
        return super.isBottom() && this.state.isBottom();
    }

    @Override
    public InferenceSystem<T> lubAux(InferenceSystem<T> other) throws SemanticException {
        InferenceSystem<T> newEnv = super.lubAux(other);
        return new InferenceSystem<InferredValue>((InferredValue)newEnv.lattice, newEnv.function, (InferredValue)this.state.lub(other.state));
    }

    @Override
    public InferenceSystem<T> wideningAux(InferenceSystem<T> other) throws SemanticException {
        InferenceSystem<T> newEnv = super.wideningAux(other);
        return new InferenceSystem<InferredValue>((InferredValue)newEnv.lattice, newEnv.function, (InferredValue)this.state.widening(other.state));
    }

    @Override
    public InferenceSystem<T> glbAux(InferenceSystem<T> other) throws SemanticException {
        InferenceSystem<T> newEnv = super.glbAux(other);
        return new InferenceSystem<InferredValue>((InferredValue)newEnv.lattice, newEnv.function, (InferredValue)this.state.glb(other.state));
    }

    @Override
    public InferenceSystem<T> narrowingAux(InferenceSystem<T> other) throws SemanticException {
        InferenceSystem<T> newEnv = super.narrowingAux(other);
        return new InferenceSystem<InferredValue>((InferredValue)newEnv.lattice, newEnv.function, (InferredValue)this.state.narrowing(other.state));
    }

    @Override
    public boolean lessOrEqualAux(InferenceSystem<T> other) throws SemanticException {
        if (!super.lessOrEqualAux(other)) {
            return false;
        }
        return this.state.lessOrEqual(other.state);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InferenceSystem other = (InferenceSystem)obj;
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    @Override
    public StructuredRepresentation representation() {
        if (this.isBottom() || this.isTop()) {
            return super.representation();
        }
        return new ObjectRepresentation(Map.of("map", super.representation(), "state", this.state.representation()));
    }
}

