/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.inference;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.NullConstant;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.LogicalAnd;
import it.unive.lisa.symbolic.value.operator.binary.LogicalOr;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeConv;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.LogicalNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.type.Type;
import java.lang.reflect.Array;
import java.util.Set;

public interface BaseInferredValue<T extends BaseInferredValue<T>>
extends BaseLattice<T>,
InferredValue<T> {
    @Override
    default public Satisfiability satisfies(ValueExpression expression, InferenceSystem<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof Identifier) {
            InferredValue.InferredPair<T> eval = this.evalIdentifier((Identifier)expression, environment, pp, oracle);
            return this.satisfiesAbstractValue((BaseInferredValue)eval.getInferred(), (BaseInferredValue)eval.getState(), pp, oracle);
        }
        if (expression instanceof NullConstant) {
            return this.satisfiesNullConstant((BaseInferredValue)environment.getExecutionState(), pp, oracle);
        }
        if (expression instanceof Constant) {
            return this.satisfiesNonNullConstant((Constant)expression, (BaseInferredValue)environment.getExecutionState(), pp, oracle);
        }
        if (expression instanceof PushAny) {
            return this.satisfiesPushAny((PushAny)expression, (BaseInferredValue)environment.getExecutionState(), oracle);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)expression;
            if (unary.getOperator() == LogicalNegation.INSTANCE) {
                return this.satisfies((ValueExpression)unary.getExpression(), environment, pp, oracle).negate();
            }
            InferredValue.InferredPair<T> arg = this.eval((ValueExpression)unary.getExpression(), environment, pp, oracle);
            if (arg.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            return this.satisfiesUnaryExpression(unary.getOperator(), (BaseInferredValue)arg.getInferred(), (BaseInferredValue)environment.getExecutionState(), pp, oracle);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() == LogicalAnd.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp, oracle).and(this.satisfies((ValueExpression)binary.getRight(), environment, pp, oracle));
            }
            if (binary.getOperator() == LogicalOr.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp, oracle).or(this.satisfies((ValueExpression)binary.getRight(), environment, pp, oracle));
            }
            InferredValue.InferredPair<T> left = this.eval((ValueExpression)binary.getLeft(), environment, pp, oracle);
            if (left.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            InferredValue.InferredPair<T> right = this.eval((ValueExpression)binary.getRight(), environment, pp, oracle);
            if (right.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            return this.satisfiesBinaryExpression(binary.getOperator(), (BaseInferredValue)left.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)environment.getExecutionState(), pp, oracle);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            InferredValue.InferredPair<T> left = this.eval((ValueExpression)ternary.getLeft(), environment, pp, oracle);
            if (left.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            InferredValue.InferredPair<T> middle = this.eval((ValueExpression)ternary.getMiddle(), environment, pp, oracle);
            if (middle.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            InferredValue.InferredPair<T> right = this.eval((ValueExpression)ternary.getRight(), environment, pp, oracle);
            if (right.isBottom()) {
                return Satisfiability.BOTTOM;
            }
            return this.satisfiesTernaryExpression(ternary.getOperator(), (BaseInferredValue)left.getInferred(), (BaseInferredValue)middle.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)environment.getExecutionState(), pp, oracle);
        }
        return Satisfiability.UNKNOWN;
    }

    @Override
    default public InferredValue.InferredPair<T> eval(ValueExpression expression, InferenceSystem<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (InferredValue.InferredPair)((Object)expression.accept(new EvaluationVisitor<BaseInferredValue>(this), environment, pp, oracle));
    }

    default public InferredValue.InferredPair<T> evalIdentifier(Identifier id, InferenceSystem<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair<BaseInferredValue>(this, (BaseInferredValue)environment.getState(id), (BaseInferredValue)environment.getExecutionState());
    }

    default public InferredValue.InferredPair<T> evalSkip(Skip skip, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue bot = (BaseInferredValue)this.bottom();
        return new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot);
    }

    default public InferredValue.InferredPair<T> evalPushAny(PushAny pushAny, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public InferredValue.InferredPair<T> evalPushInv(PushInv pushInv, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue bot = (BaseInferredValue)this.bottom();
        return new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot);
    }

    default public InferredValue.InferredPair<T> evalNullConstant(T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public InferredValue.InferredPair<T> evalNonNullConstant(Constant constant, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public InferredValue.InferredPair<T> evalUnaryExpression(UnaryOperator operator, T arg, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public InferredValue.InferredPair<T> evalBinaryExpression(BinaryOperator operator, T left, T right, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public InferredValue.InferredPair<T> evalTypeConv(BinaryExpression conv, T left, T right, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue bot = (BaseInferredValue)this.bottom();
        return oracle.getRuntimeTypesOf(conv, pp, oracle).isEmpty() ? new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot) : new InferredValue.InferredPair<BaseInferredValue>(this, (BaseInferredValue)left, (BaseInferredValue)state);
    }

    default public InferredValue.InferredPair<T> evalTypeCast(BinaryExpression cast, T left, T right, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue bot = (BaseInferredValue)this.bottom();
        return oracle.getRuntimeTypesOf(cast, pp, oracle).isEmpty() ? new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot) : new InferredValue.InferredPair<BaseInferredValue>(this, (BaseInferredValue)left, (BaseInferredValue)state);
    }

    default public InferredValue.InferredPair<T> evalTernaryExpression(TernaryOperator operator, T left, T middle, T right, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public InferredValue.InferredPair<T> evalValueExpression(ValueExpression expression, T[] subExpressions, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    default public Satisfiability satisfiesAbstractValue(T value, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesPushAny(PushAny pushAny, T state, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesNullConstant(T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesNonNullConstant(Constant constant, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesUnaryExpression(UnaryOperator operator, T arg, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, T left, T right, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    default public Satisfiability satisfiesTernaryExpression(TernaryOperator operator, T left, T middle, T right, T state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    @Override
    default public boolean canProcess(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        if (expression instanceof PushInv) {
            return expression.getStaticType().isValueType();
        }
        Set<Type> rts = null;
        try {
            rts = oracle.getRuntimeTypesOf(expression, pp, oracle);
        }
        catch (SemanticException e) {
            return false;
        }
        if (rts == null || rts.isEmpty()) {
            return true;
        }
        return rts.stream().anyMatch(Type::isValueType);
    }

    @Override
    default public InferenceSystem<T> assume(InferenceSystem<T> environment, ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        Satisfiability sat = this.satisfies(expression, environment, src, oracle);
        if (sat == Satisfiability.NOT_SATISFIED) {
            return environment.bottom();
        }
        if (sat == Satisfiability.SATISFIED) {
            return new InferenceSystem<BaseInferredValue>((BaseInferredValue)environment.lattice, environment.function, (BaseInferredValue)this.eval(expression, environment, src, oracle).getState());
        }
        return environment;
    }

    public static class EvaluationVisitor<T extends BaseInferredValue<T>>
    implements ExpressionVisitor<InferredValue.InferredPair<T>> {
        private static final String CANNOT_PROCESS_ERROR = "Cannot process a heap expression with an inferred value domain";
        private final T singleton;

        public EvaluationVisitor(T singleton) {
            this.singleton = singleton;
        }

        public InferredValue.InferredPair<T> visit(HeapExpression expression, InferredValue.InferredPair<T>[] subExpressions, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(AccessChild expression, InferredValue.InferredPair<T> receiver, InferredValue.InferredPair<T> child, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(MemoryAllocation expression, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(HeapReference expression, InferredValue.InferredPair<T> arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(HeapDereference expression, InferredValue.InferredPair<T> arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(UnaryExpression expression, InferredValue.InferredPair<T> arg, Object ... params) throws SemanticException {
            if (((BaseInferredValue)arg.getInferred()).isBottom()) {
                return arg;
            }
            return this.singleton.evalUnaryExpression(expression.getOperator(), (BaseInferredValue)((BaseInferredValue)arg.getInferred()), (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(BinaryExpression expression, InferredValue.InferredPair<T> left, InferredValue.InferredPair<T> right, Object ... params) throws SemanticException {
            if (((BaseInferredValue)left.getInferred()).isBottom()) {
                return left;
            }
            if (((BaseInferredValue)right.getInferred()).isBottom()) {
                return right;
            }
            if (expression.getOperator() == TypeCast.INSTANCE) {
                return this.singleton.evalTypeCast(expression, (BaseInferredValue)((BaseInferredValue)left.getInferred()), (BaseInferredValue)((BaseInferredValue)right.getInferred()), (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
            }
            if (expression.getOperator() == TypeConv.INSTANCE) {
                return this.singleton.evalTypeConv(expression, (BaseInferredValue)((BaseInferredValue)left.getInferred()), (BaseInferredValue)((BaseInferredValue)right.getInferred()), (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
            }
            return this.singleton.evalBinaryExpression(expression.getOperator(), (BaseInferredValue)((BaseInferredValue)left.getInferred()), (BaseInferredValue)((BaseInferredValue)right.getInferred()), (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(TernaryExpression expression, InferredValue.InferredPair<T> left, InferredValue.InferredPair<T> middle, InferredValue.InferredPair<T> right, Object ... params) throws SemanticException {
            if (((BaseInferredValue)left.getInferred()).isBottom()) {
                return left;
            }
            if (((BaseInferredValue)middle.getInferred()).isBottom()) {
                return middle;
            }
            if (((BaseInferredValue)right.getInferred()).isBottom()) {
                return right;
            }
            return this.singleton.evalTernaryExpression(expression.getOperator(), (BaseInferredValue)((BaseInferredValue)left.getInferred()), (BaseInferredValue)((BaseInferredValue)middle.getInferred()), (BaseInferredValue)((BaseInferredValue)right.getInferred()), (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(Skip expression, Object ... params) throws SemanticException {
            return this.singleton.evalSkip(expression, (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(PushAny expression, Object ... params) throws SemanticException {
            return this.singleton.evalPushAny(expression, (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(PushInv expression, Object ... params) throws SemanticException {
            return this.singleton.evalPushInv(expression, (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(Constant expression, Object ... params) throws SemanticException {
            if (expression instanceof NullConstant) {
                return this.singleton.evalNullConstant((BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
            }
            return this.singleton.evalNonNullConstant(expression, (BaseInferredValue)((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState()), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(Identifier expression, Object ... params) throws SemanticException {
            return this.singleton.evalIdentifier(expression, (InferenceSystem)params[0], (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }

        public InferredValue.InferredPair<T> visit(ValueExpression expression, InferredValue.InferredPair<T>[] subExpressions, Object ... params) throws SemanticException {
            BaseInferredValue[] subs = null;
            if (subExpressions != null && subExpressions.length > 0) {
                subs = (BaseInferredValue[])Array.newInstance(((BaseInferredValue)subExpressions[0].getInferred()).getClass(), subExpressions.length);
                for (int i = 0; i < subExpressions.length; ++i) {
                    if (subExpressions[i].isBottom()) {
                        return subExpressions[i];
                    }
                    subs[i] = (BaseInferredValue)subExpressions[i].getInferred();
                }
            }
            return this.singleton.evalValueExpression(expression, subs, (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1], (SemanticOracle)params[2]);
        }
    }
}

