/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HeapEnvironment<T extends NonRelationalHeapDomain<T>>
extends Environment<HeapEnvironment<T>, SymbolicExpression, T>
implements HeapDomain<HeapEnvironment<T>> {
    private final List<HeapSemanticOperation.HeapReplacement> substitution;

    public HeapEnvironment(T domain) {
        super(domain);
        this.substitution = Collections.emptyList();
    }

    public HeapEnvironment(T domain, Map<Identifier, T> function) {
        this(domain, function, Collections.emptyList());
    }

    public HeapEnvironment(T domain, Map<Identifier, T> function, List<HeapSemanticOperation.HeapReplacement> substitution) {
        super(domain, function);
        this.substitution = substitution;
    }

    @Override
    public HeapEnvironment<T> mk(T lattice, Map<Identifier, T> function) {
        return new HeapEnvironment<T>(lattice, function);
    }

    @Override
    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return ((NonRelationalHeapDomain)this.lattice).rewrite(expression, this, pp, oracle);
    }

    @Override
    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return this.substitution;
    }

    @Override
    public HeapEnvironment<T> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this;
        }
        NonRelationalHeapDomain eval = (NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).eval(expression, this, pp, oracle);
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)this.lattice, this.function, eval.getSubstitution());
    }

    @Override
    public HeapEnvironment<T> top() {
        return this.isTop() ? this : new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).top(), null, Collections.emptyList());
    }

    @Override
    public HeapEnvironment<T> bottom() {
        return this.isBottom() ? this : new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).bottom(), null, Collections.emptyList());
    }

    @Override
    public boolean isTop() {
        return super.isTop() && this.substitution.isEmpty();
    }

    @Override
    public boolean isBottom() {
        return super.isBottom() && this.substitution.isEmpty();
    }

    @Override
    public boolean lessOrEqualAux(HeapEnvironment<T> other) throws SemanticException {
        return super.lessOrEqualAux(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.substitution == null ? 0 : this.substitution.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeapEnvironment other = (HeapEnvironment)obj;
        return !(this.substitution == null ? other.substitution != null : !this.substitution.equals(other.substitution));
    }

    @Override
    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return ((NonRelationalHeapDomain)this.lattice).alias(x, y, this, pp, oracle);
    }

    @Override
    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return ((NonRelationalHeapDomain)this.lattice).isReachableFrom(x, y, this, pp, oracle);
    }
}

