/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.NonRelationalElement;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public abstract class VariableLift<M extends VariableLift<M, E, T>, E extends SymbolicExpression, T extends NonRelationalElement<T, E, M>>
extends FunctionalLattice<M, Identifier, T>
implements SemanticDomain<M, E, Identifier> {
    public VariableLift(T domain) {
        super(domain);
    }

    public VariableLift(T domain, Map<Identifier, T> function) {
        super(domain, function);
    }

    @Override
    public Satisfiability satisfies(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        return ((NonRelationalElement)this.lattice).satisfies(expression, this, pp, oracle);
    }

    @Override
    public M pushScope(ScopeToken scope) throws SemanticException {
        AtomicReference holder = new AtomicReference();
        M result = this.liftIdentifiers(id -> {
            try {
                return (Identifier)id.pushScope(scope);
            }
            catch (SemanticException e) {
                holder.set(e);
                return null;
            }
        });
        if (holder.get() != null) {
            throw new SemanticException("Pushing the scope '" + scope + "' raised an error", (Throwable)holder.get());
        }
        return result;
    }

    @Override
    public M popScope(ScopeToken scope) throws SemanticException {
        AtomicReference holder = new AtomicReference();
        M result = this.liftIdentifiers(id -> {
            try {
                return (Identifier)id.popScope(scope);
            }
            catch (SemanticException e) {
                holder.set(e);
                return null;
            }
        });
        if (holder.get() != null) {
            throw new SemanticException("Popping the scope '" + scope + "' raised an error", (Throwable)holder.get());
        }
        return result;
    }

    private M liftIdentifiers(UnaryOperator<Identifier> lifter) throws SemanticException {
        if (this.isBottom() || this.isTop()) {
            return (M)this;
        }
        Map<Identifier, NonRelationalElement> function = this.mkNewFunction(null, false);
        for (Identifier id : this.getKeys()) {
            Identifier lifted = (Identifier)lifter.apply(id);
            if (lifted == null) continue;
            if (!function.containsKey(lifted)) {
                function.put(lifted, (NonRelationalElement)this.getState(id));
                continue;
            }
            function.put(lifted, ((NonRelationalElement)this.getState(id)).lub((NonRelationalElement)function.get(lifted)));
        }
        return (M)((VariableLift)this.mk((NonRelationalElement)this.lattice, function));
    }

    @Override
    public M forgetIdentifier(Identifier id) throws SemanticException {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return (M)this;
        }
        Map result = this.mkNewFunction(this.function, false);
        if (result.containsKey(id)) {
            result.remove(id);
        }
        return (M)((VariableLift)this.mk((NonRelationalElement)this.lattice, result));
    }

    @Override
    public M forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return (M)this;
        }
        Map result = this.mkNewFunction(this.function, false);
        Set<Identifier> keys = result.keySet().stream().filter(test::test).collect(Collectors.toSet());
        keys.forEach(result::remove);
        return (M)((VariableLift)this.mk((NonRelationalElement)this.lattice, result));
    }

    @Override
    public Set<Identifier> lubKeys(Set<Identifier> k1, Set<Identifier> k2) throws SemanticException {
        HashSet<Identifier> keys = new HashSet<Identifier>();
        CollectionsDiffBuilder<Identifier> builder = new CollectionsDiffBuilder<Identifier>(Identifier.class, k1, k2);
        builder.compute(Comparator.comparing(Identifier::getName));
        keys.addAll(builder.getOnlyFirst());
        keys.addAll(builder.getOnlySecond());
        for (Pair<Identifier, Identifier> pair : builder.getCommons()) {
            try {
                keys.add(((Identifier)pair.getLeft()).lub((Identifier)pair.getRight()));
            }
            catch (SemanticException e) {
                throw new SemanticException("Unable to lub " + pair.getLeft() + " and " + pair.getRight(), e);
            }
        }
        return keys;
    }

    @Override
    public T stateOfUnknown(Identifier key) {
        return ((NonRelationalElement)this.lattice).unknownVariable(key);
    }

    @Override
    public boolean knowsIdentifier(Identifier id) {
        return this.getKeys().contains(id);
    }
}

