/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.nonrelational.NonRelationalDomain;
import it.unive.lisa.analysis.nonrelational.VariableLift;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import java.util.Map;

public abstract class Environment<M extends Environment<M, E, T>, E extends SymbolicExpression, T extends NonRelationalDomain<T, E, M>>
extends VariableLift<M, E, T> {
    public Environment(T domain) {
        super(domain);
    }

    public Environment(T domain, Map<Identifier, T> function) {
        super(domain, function);
    }

    @Override
    public M assign(Identifier id, E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return (M)this;
        }
        if (!((NonRelationalDomain)this.lattice).canProcess((SymbolicExpression)expression, pp, oracle)) {
            return (M)this;
        }
        Map<Identifier, Object> func = this.mkNewFunction(this.function, false);
        Object value = ((NonRelationalDomain)this.lattice).eval(expression, this, pp, oracle);
        NonRelationalDomain v = (NonRelationalDomain)((NonRelationalDomain)this.lattice).fixedVariable(id, pp, oracle);
        if (!v.isBottom()) {
            value = v;
        } else if (id.isWeak() && this.function != null && this.function.containsKey(id)) {
            value = value.lub((NonRelationalDomain)((NonRelationalDomain)this.getState(id)));
        }
        func.put(id, value);
        return (M)((Environment)this.mk((NonRelationalDomain)this.lattice, func));
    }

    @Override
    public M smallStepSemantics(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (M)this;
    }

    public T eval(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return ((NonRelationalDomain)this.lattice).eval(expression, this, pp, oracle);
    }

    @Override
    public M assume(E expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return (M)this;
        }
        return (M)((NonRelationalDomain)this.lattice).assume(this, expression, src, dest, oracle);
    }
}

