/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.util.representation.SetRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class SetLattice<S extends SetLattice<S, E>, E>
implements BaseLattice<S>,
Iterable<E> {
    public final Set<E> elements;
    public final boolean isTop;

    public SetLattice(Set<E> elements, boolean isTop) {
        this.elements = elements;
        this.isTop = isTop;
    }

    public abstract S mk(Set<E> var1);

    @Override
    public S lubAux(S other) throws SemanticException {
        HashSet<E> lub = new HashSet<E>(this.elements);
        lub.addAll(((SetLattice)other).elements);
        return this.mk(lub);
    }

    @Override
    public S glbAux(S other) throws SemanticException {
        HashSet<E> glb = new HashSet<E>(this.elements);
        glb.retainAll(((SetLattice)other).elements);
        return this.mk(glb);
    }

    @Override
    public boolean lessOrEqualAux(S other) throws SemanticException {
        return ((SetLattice)other).elements.containsAll(this.elements);
    }

    @Override
    public boolean isTop() {
        return this.isTop && this.elements.isEmpty();
    }

    @Override
    public boolean isBottom() {
        return !this.isTop && this.elements.isEmpty();
    }

    public boolean contains(E elem) {
        return this.elements.contains(elem);
    }

    public Set<E> elements() {
        return this.elements;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetLattice other = (SetLattice)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return this.isTop == other.isTop;
    }

    @Override
    public final String toString() {
        if (this.isTop()) {
            return "#TOP#";
        }
        if (this.isBottom()) {
            return "_|_";
        }
        return this.elements.toString();
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public StructuredRepresentation representation() {
        return new SetRepresentation(this.elements, StringRepresentation::new);
    }
}

